<?php
require_once "config.php";

$message = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $first_name = trim($_POST["first_name"]);
    $last_name  = trim($_POST["last_name"]);
    $email      = trim($_POST["email"]);
    $phone      = trim($_POST["phone"]);
    $username   = trim($_POST["username"]);
    $password   = password_hash($_POST["password"], PASSWORD_DEFAULT);

    // Handle image upload
    $image = "default_admin.png"; // default image in uploads/
    if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $allowed = ['jpg','jpeg','png','gif'];
        if (in_array(strtolower($ext), $allowed)) {
            $new_name = uniqid('admin_') . "." . $ext;
            $target_dir = "uploads/";
            if (move_uploaded_file($_FILES['image']['tmp_name'], $target_dir . $new_name)) {
                $image = $new_name;
            }
        }
    }

    // Insert admin user
    $stmt = $conn->prepare("INSERT INTO users 
        (first_name, last_name, email, phone, username, password, role, subscription_plan, currency, balance, image) 
        VALUES (?, ?, ?, ?, ?, ?, 'admin', 'basic', 'NGN', 0.00, ?)");
    $stmt->bind_param("sssssss", $first_name, $last_name, $email, $phone, $username, $password, $image);

    if ($stmt->execute()) {
        $message = "Admin registered successfully. Redirecting to login...";
        header("refresh:2;url=login.php");
        exit;
    } else {
        $message = "Error: " . $stmt->error;
    }

    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Register Admin</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
  <style>
    body { background: #f0f2f5; }
    .reg-card {
      max-width: 500px;
      margin: 60px auto;
      background: #fff;
      border-radius: 12px;
      padding: 25px;
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    .btn-custom { background: #4a6cf7; color: #fff; }
    .btn-custom:hover { background: #3955c3; }
  </style>
</head>
<body>
  <div class="reg-card">
    <h3 class="text-center mb-4"><i class="fas fa-user-shield me-2"></i>Register Admin</h3>
    <?php if ($message): ?>
      <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>
    <form action="admin_reg.php" method="POST" enctype="multipart/form-data">
      <div class="mb-3">
        <label class="form-label">First Name</label>
        <input type="text" name="first_name" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Last Name</label>
        <input type="text" name="last_name" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Phone</label>
        <input type="text" name="phone" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Username</label>
        <input type="text" name="username" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Password</label>
        <input type="password" name="password" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Profile Image (optional)</label>
        <input type="file" name="image" class="form-control" accept="image/*">
      </div>
      <div class="d-grid">
        <button type="submit" class="btn btn-custom"><i class="fas fa-user-plus me-1"></i> Register Admin</button>
      </div>
    </form>
  </div>
</body>
</html>
