<?php
// check_username.php
require_once "config.php"; // make sure this connects to your DB

if (isset($_GET['username'])) {
    $username = trim($_GET['username']);

    if ($username === '') {
        echo json_encode([
            "available" => false,
            "message" => "Username cannot be empty."
        ]);
        exit;
    }

    // prepare and query
    $stmt = $conn->prepare("SELECT id FROM users WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        echo json_encode([
            "available" => false,
            "message" => "Username already taken."
        ]);
    } else {
        echo json_encode([
            "available" => true,
            "message" => "Username is available."
        ]);
    }

    $stmt->close();
}
?>
