<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <!-- Meta Pixel Code -->
<script>
!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window, document,'script',
'https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '1334408188078519');
fbq('track', 'PageView');
</script>
<noscript><img height="1" width="1" style="display:none"
src="https://www.facebook.com/tr?id=1334408188078519&ev=PageView&noscript=1"
/></noscript>
<!-- End Meta Pixel Code -->
  <title>Limac Group - Index</title>

   <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <!-- Global CSS (small base + variables). Section-specific CSS/JS will live inside each <section>. -->
  <link rel="stylesheet" href="global.css">

  <!-- Global CSS (small base + variables). Section-specific CSS/JS will live inside each <section>. -->
  <link rel="stylesheet" href="global.css">

  <style>
    :root{
      --accent: #0d6efd;
      --muted: #6c757d;
      --bg: #f7fbff;
      --radius: 12px;
      --max-width: 1200px;
    }
    * { box-sizing: border-box; }
    html, body { height: 100%; }
    body {
      margin: 0;
      font-family: Inter, system-ui, -apple-system, 'Segoe UI', Roboto, 'Helvetica Neue', Arial;
      background: var(--bg);
      color: #0b1220;
    }
    body, html {
  overflow-x: hidden; /* Prevent horizontal scroll */
}
    .container { max-width: var(--max-width); margin: 0 auto; padding: 0 1rem; }
    .py-5 { padding-top: 3rem; padding-bottom: 3rem; }
    .section-placeholder {
      min-height: 120px;
      border-radius: 8px;
      border: 2px dashed rgba(11,18,32,0.06);
      display: flex;
      align-items: center;
      justify-content: center;
      color: var(--muted);
      background: transparent;
    }
    header, footer { background: transparent; }
    .dev-note { font-size: 0.95rem; color: var(--muted); text-align: center; margin-top: 0.75rem; }

       /* ===== Animations ===== */
    @keyframes slideDown {
      from { transform: translateY(-100%); opacity: 0; }
      to { transform: translateY(0); opacity: 1; }
    }
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(-15px); }
      to { opacity: 1; transform: translateY(0); }
    }



    /* ===== Topbar ===== */
    .topbar {
      background: #0d6efd;
      color: #fff;
      font-size: 13px;
      padding: 6px 20px;
      animation: slideDown 0.7s ease-in-out;
    }
    .topbar i {
      margin-right: 6px;
      color: #ffd700;
    }
    .topbar a {
      color: #fff;
      margin-left: 12px;
      text-decoration: none;
    }

    /* ===== Navbar ===== */
    .navbar {
      animation: fadeIn 1s ease-in-out;
      background: #fff;
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    .navbar-brand img {
      height: 40px;
      margin-right: 10px;
    }

    /* ===== Nav Buttons ===== */
    .navbar-nav .nav-link {
      display: inline-flex;
      align-items: center;
      gap: 6px;
      font-weight: 500;
      border-radius: 30px;
      padding: 6px 14px;
      transition: all 0.3s ease;
      color: #0d6efd !important;
      border: 1px solid #0d6efd;
      margin-left: 8px;
    }
    .navbar-nav .nav-link:hover {
      background: #0d6efd;
      color: #fff !important;
    }

    .navbar-toggler {
      border: none;
      font-size: 22px;
    }

    /* ===== Mobile Menu Animation ===== */
    .offcanvas {
      animation: fadeIn 0.5s ease-in-out;
    }


     /* HERO SECTION */
    .hero {
      width: 100%;
      height: 100vh;
      position: relative;
      overflow: hidden;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .swiper {
      width: 100%;
      height: 100%;
    }

    .swiper-slide {
      position: relative;
      display: flex;
      align-items: center;
      justify-content: center;
      text-align: center;
      color: #fff;
      font-size: 1.2rem;
      overflow: hidden;
    }

    /* Background Image with Ken Burns effect */
    .swiper-slide::before {
      content: "";
      position: absolute;
      top: 0; left: 0;
      width: 100%; height: 100%;
      background-size: cover;
      background-position: center;
      z-index: 1;
      transform: scale(1);
      animation: kenburns 12s ease-in-out infinite alternate;
    }

    .swiper-slide[data-bg]::before {
      background-image: attr(data-bg url);
    }

    /* Ken Burns Animation */
    @keyframes kenburns {
      from { transform: scale(1) translate(0,0); }
      to   { transform: scale(1.2) translate(-20px, -20px); }
    }

    /* Caption Overlay */
    .slide-content {
      position: relative;
      z-index: 2;
      max-width: 700px;
      padding: 20px;
      background: rgba(0, 0, 0, 0.4);
      border-radius: 10px;
      animation: fadeInUp 1.2s ease;
    }

    .slide-content h2 {
      font-size: 2.5rem;
      margin-bottom: 15px;
    }

    .slide-content p {
      font-size: 1.1rem;
      margin-bottom: 20px;
    }

    .slide-content a {
      padding: 12px 24px;
      background: #0d6efd;
      color: #fff;
      text-decoration: none;
      border-radius: 5px;
      font-weight: bold;
      transition: 0.3s;
    }

    .slide-content a:hover {
      background: #084298;
    }

    /* Navigation */
    .swiper-button-next, .swiper-button-prev {
      color: #fff;
    }

    /* Pagination */
    .swiper-pagination-bullet {
      background: #fff;
      opacity: 0.8;
    }

    .swiper-pagination-bullet-active {
      background: #0d6efd;
    }

    /* Animations */
    @keyframes fadeInUp {
      from { opacity: 0; transform: translateY(30px); }
      to   { opacity: 1; transform: translateY(0); }
    }

    /* Responsive */
    @media (max-width: 768px) {
      .slide-content h2 {
        font-size: 1.8rem;
      }
      .slide-content p {
        font-size: 1rem;
      }
    }
  </style>



 
</head>
<body>

 <!-- ===== Topbar ===== -->
  <div class="topbar d-flex flex-wrap justify-content-between align-items-center">
    <div>
      <i class="fa-solid fa-phone"></i> +234 706 697 2694
      <i class="fa-solid fa-envelope ms-3"></i> contact@limacgroup.com
      <i class="fa-solid fa-location-dot ms-3"></i> Second floor, P&T Plaza beside Jodil Filling Station, SARS Road, Rupokwu.
      <i class="fa-solid fa-clock ms-3"></i> Mon - Sat: 9:00 - 17:00
    </div>
    <div>
      <a href="https://www.facebook.com/share/15neJ5DBPE/"><i class="fab fa-facebook"></i></a>
      <a href="#"><i class="fab fa-twitter"></i></a>
      <a href="https://www.instagram.com/limaccourtslimited?igsh=MWM5a3gwZHNoMWt0aA==">
  <i class="fab fa-instagram"></i>
</a>

    </div>
  </div>

  <!-- ===== Navbar ===== -->
  <nav class="navbar navbar-expand-lg sticky-top">
    <div class="container">
      <!-- Logo + Name -->
      <a class="navbar-brand d-flex align-items-center" href="#">
        <img src="images/limac.jpeg" alt="Logo">
        <span class="fw-bold text-primary">Limac Group</span>
      </a>

      <!-- Hamburger -->
      <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#mainNav">
        <i class="fa-solid fa-bars"></i>
      </button>

      <!-- Offcanvas Menu -->
      <div class="offcanvas offcanvas-end" tabindex="-1" id="mainNav">
        <div class="offcanvas-header">
          <h5 class="offcanvas-title">Menu</h5>
          <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
        </div>
        <div class="offcanvas-body">
          <ul class="navbar-nav ms-auto">
            <li class="nav-item"><a class="nav-link" href="index.php"><i class="fa-solid fa-house"></i> Home</a></li>
            <li class="nav-item"><a class="nav-link" href="#about"><i class="fa-solid fa-cogs"></i> Our Service</a></li>
            <li class="nav-item"><a class="nav-link" href="#admin-properties"><i class="fa-solid fa-building"></i> Premium Estates</a></li>
            <li class="nav-item"><a class="nav-link" href="#properties"><i class="fa-solid fa-star"></i> Featured Properties</a></li>
            <li class="nav-item"><a class="nav-link" href="#contact"><i class="fa-solid fa-envelope"></i> Contact</a></li>
            <li class="nav-item"><a class="nav-link" href="login.php"><i class="fa-solid fa-user"></i> Login</a></li>
          </ul>
        </div>
      </div>
    </div>
  </nav>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />



<!-- ===== HERO SECTION ===== -->
<section class="hero">
  <div class="swiper mySwiper">
    <div class="swiper-wrapper">
      
      <!-- Slide 1 -->
      <div class="swiper-slide" style="background-image:url('https://images.unsplash.com/photo-1600585154340-be6161a56a0c?auto=format&fit=crop&w=1500&q=80');">
        <div class="slide-content">
          <h2>Welcome to Limac Group</h2>
          <p>Your trusted partner in finding the perfect property.</p>
          <a href="#properties" class="btn btn-primary">Get Started</a>
        </div>
      </div>

      <!-- Slide 2 -->
      <div class="swiper-slide" style="background-image:url('images/renta.jpeg');">
        <div class="slide-content">
          <h2>Our Services</h2>
          <p>Explore a wide range of real estate services tailored to your needs.</p>
          <a href="#services" class="btn btn-primary">Discover More</a>
        </div>
      </div>

      <!-- Slide 3 -->
      <div class="swiper-slide" style="background-image:url('https://images.unsplash.com/photo-1572120360610-d971b9d7767c?auto=format&fit=crop&w=1500&q=80');">
        <div class="slide-content">
          <h2>Premium Estates</h2>
          <p>Exclusive listings of luxury homes and estates just for you.</p>
          <a href="#estates" class="btn btn-primary">View Estates</a>
        </div>
      </div>

      <!-- Slide 4 -->
      <div class="swiper-slide" style="background-image:url('https://images.unsplash.com/photo-1502672023488-70e25813eb80?auto=format&fit=crop&w=1500&q=80');">
        <div class="slide-content">
          <h2>Featured Properties</h2>
          <p>Hand-picked properties that fit your style and budget.</p>
          <a href="#properties" class="btn btn-primary">Browse Properties</a>
        </div>
      </div>

    </div>

    <!-- Navigation -->
    <div class="swiper-button-next"></div>
    <div class="swiper-button-prev"></div>
    <div class="swiper-pagination"></div>
  </div>

  <!-- CSS -->
  <style>
    .hero { position: relative; height: 90vh; }
    .swiper-slide {
      background-size: cover;
      background-position: center;
      position: relative;
    }
    .slide-content {
      position: absolute;
      bottom: 50px;
      left: 50%;
      transform: translateX(-50%);
      text-align: center;
      color: #fff;
      max-width: 800px;
      padding: 0 15px;
    }
    .slide-content h2 { font-size: 2.5rem; margin-bottom: 15px; text-shadow: 1px 1px 8px rgba(0,0,0,0.7); }
    .slide-content p { font-size: 1.1rem; margin-bottom: 20px; text-shadow: 1px 1px 6px rgba(0,0,0,0.6); }
    .slide-content .btn {
      font-weight: 600;
      padding: 10px 25px;
      font-size: 1rem;
      border-radius: 6px;
    }

    /* Responsive */
    @media (max-width: 768px){
      .slide-content h2 { font-size: 1.8rem; }
      .slide-content p { font-size: 1rem; }
    }
  </style>

  <!-- Swiper JS -->
  <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
  <script>
    var swiper = new Swiper(".mySwiper", {
      loop: true,
      autoplay: {
        delay: 5000,
        disableOnInteraction: false,
      },
      pagination: {
        el: ".swiper-pagination",
        clickable: true,
      },
      navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev",
      },
      effect: "fade",
      fadeEffect: { crossFade: true }
    });
  </script>
</section>

<section id="about" class="py-5" style="background:#f9fbfc;">
  <div class="container">
    <h3 class="text-center mb-4">About Limac Courts Limited</h3>

    <!-- Typing Effect -->
    <div class="mb-3">
      <p id="typed-text" class="lead text-center" style="min-height:150px; max-width:900px; margin:0 auto;"></p>
    </div>

    <!-- Read More Button -->
    <div class="text-center mb-5">
      <button id="readMoreBtn" class="btn btn-primary d-none">Read More</button>
    </div>

    <!-- Hidden Content -->
    <div id="moreContent" style="display:none;">
      
      <!-- Services -->
      <div class="row text-center mb-5">
        <h4 class="fw-bold mb-4">Our Services</h4>
        <div class="col-md-4 mb-3">
          <div class="card h-100 shadow-sm border-0">
            <div class="card-body">
              <div class="text-primary fs-1 mb-3"><i class="fas fa-map-marked-alt"></i></div>
              <h6 class="fw-bold">Land Sales</h6>
              <p class="text-muted">Affordable, verified plots in key locations across Rivers State and Nigeria.</p>
            </div>
          </div>
        </div>
        <div class="col-md-4 mb-3">
          <div class="card h-100 shadow-sm border-0">
            <div class="card-body">
              <div class="text-primary fs-1 mb-3"><i class="fas fa-hard-hat"></i></div>
              <h6 class="fw-bold">Construction Services</h6>
              <p class="text-muted">From design to completion, we build quality homes and structures tailored to your needs.</p>
            </div>
          </div>
        </div>
        <div class="col-md-4 mb-3">
          <div class="card h-100 shadow-sm border-0">
            <div class="card-body">
              <div class="text-primary fs-1 mb-3"><i class="fas fa-hand-holding-usd"></i></div>
              <h6 class="fw-bold">Flexible Payment Plans</h6>
              <p class="text-muted">Designed to suit your budget and make land ownership easy.</p>
            </div>
          </div>
        </div>
      </div>

      <!-- Why Choose Us -->
      <div class="text-center mb-5">
        <h4 class="fw-bold mb-4">Why Choose Limac Courts?</h4>
        <div class="row g-4">
          <div class="col-md-3 col-6">
            <div class="p-3 border rounded shadow-sm h-100">
              <i class="fas fa-users text-success fs-2 mb-2"></i>
              <p class="mb-0">200+ Happy Landowners</p>
            </div>
          </div>
          <div class="col-md-3 col-6">
            <div class="p-3 border rounded shadow-sm h-100">
              <i class="fas fa-file-alt text-success fs-2 mb-2"></i>
              <p class="mb-0">Genuine Land with Documents</p>
            </div>
          </div>
          <div class="col-md-3 col-6">
            <div class="p-3 border rounded shadow-sm h-100">
              <i class="fas fa-search text-success fs-2 mb-2"></i>
              <p class="mb-0">Transparent Processes</p>
            </div>
          </div>
          <div class="col-md-3 col-6">
            <div class="p-3 border rounded shadow-sm h-100">
              <i class="fas fa-building text-success fs-2 mb-2"></i>
              <p class="mb-0">End-to-End Services</p>
            </div>
          </div>
        </div>
      </div>

      <!-- CTA -->
      <div class="text-center">
        <p class="mb-2">📍 Based in Port Harcourt | Serving Clients Nationwide</p>
        <a href="https://wa.me/2347066972694" class="btn btn-success btn-lg rounded-pill">
          <i class="fab fa-whatsapp"></i> Chat with Us: 07066972694
        </a>
      </div>
    </div>
  </div>

  <!-- FontAwesome CDN -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <!-- Section-Specific Styles -->
  <style>
    #about #moreContent.fade-in {
      animation: fadeIn 1s ease-in-out;
    }
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(20px); }
      to { opacity: 1; transform: translateY(0); }
    }
  </style>

  <!-- Section-Specific Script -->
  <script>
    const aboutText = "Limac Courts Limited is a trusted real estate and construction company based in Port Harcourt, Rivers State, Nigeria. We specialize in providing affordable, secure, and strategically located plots of land for residential and commercial purposes. With over 200 satisfied clients and counting, we are committed to helping individuals, families, and investors achieve land and home ownership with ease.";
    let aboutIndex = 0;
    let aboutStarted = false;

    function typeWriter() {
      if (aboutIndex < aboutText.length) {
        document.getElementById("typed-text").innerHTML += aboutText.charAt(aboutIndex);
        aboutIndex++;
        setTimeout(typeWriter, 35);
      } else {
        document.getElementById("readMoreBtn").classList.remove("d-none");
      }
    }

    document.addEventListener("DOMContentLoaded", function() {
      const aboutSection = document.querySelector("#about");

      const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
          if (entry.isIntersecting && !aboutStarted) {
            aboutStarted = true;
            typeWriter();
            observer.unobserve(aboutSection);
          }
        });
      }, { threshold: 0.3 });

      observer.observe(aboutSection);

      document.getElementById("readMoreBtn").addEventListener("click", function() {
        const moreContent = document.getElementById("moreContent");
        moreContent.style.display = "block";
        moreContent.classList.add("fade-in");
        this.style.display = "none";
      });
    });
  </script>
</section>

<!-- Admin adverts starts here  -->

<?php
require_once "config.php";

// Fetch active homepage adverts
$adverts_res = $conn->query("
    SELECT a.id AS advert_id, p.id AS property_id, p.description, p.property_image, p.price, p.location AS prop_location
    FROM admin_adverts a
    JOIN admin_properties p ON a.admin_property_id = p.id
    WHERE a.status='active' AND a.location='homepage'
    ORDER BY a.created_at DESC
");

$adverts = [];
while($row = $adverts_res->fetch_assoc()) {
    $adverts[] = $row;
}
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
#advertPopup {
    position: fixed;
    top: 90px;
    left: 20px;
    width: 450px;
    max-width: 90%;
    z-index: 1050;
    display: none;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 6px 18px rgba(0,0,0,0.35);
    background: #fff;
}

#advertPopup img {
    width: 100%;
    height: 180px; /* fixed height for mobile */
    object-fit: cover;
}

#advertPopup .close-btn {
    position: absolute;
    top: 8px;
    right: 12px;
    font-size: 1.4rem;
    cursor: pointer;
    color: #fff;
    background: rgba(0,0,0,0.5);
    border-radius: 50%;
    padding: 0 6px;
    z-index: 2;
}

#advertPopup .card-body {
    display: flex;
    flex-direction: column;
    gap: 4px;
    padding: 8px;
}

#advertPopup .card-body p {
    margin: 0;
    font-size: 0.95rem;
}

#advertPopup .card-body a.btn {
    margin-top: 0;
    align-self: flex-start;
}

/* Slide-in / Slide-out */
@keyframes slideInLeft {
    0% { transform: translateX(-120%); opacity: 0; }
    100% { transform: translateX(0); opacity: 1; }
}

@keyframes slideOutLeft {
    0% { transform: translateX(0); opacity: 1; }
    100% { transform: translateX(-120%); opacity: 0; }
}

/* Pulse animation */
@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.03); }
}

.pulse {
    animation: pulse 1s infinite;
}

@media(min-width:992px){
    #advertPopup img { height: 390px; } /* taller image for desktop */
}
</style>

<div id="advertPopup">
    <span class="close-btn">&times;</span>
    <div class="card h-auto">
        <img id="advertImg" src="" alt="Property">
        <div class="card-body">
            <p id="advertDesc"><strong>Description:</strong></p>
            <p id="advertPrice"><strong>Price:</strong></p>
            <p id="advertLocation"><strong>Location:</strong></p>
            <a href="#" id="viewAdvertBtn" class="btn btn-warning btn-sm">View Details</a>
        </div>
    </div>
</div>

<script>
const adverts = <?php echo json_encode($adverts); ?>;
let currentIndex = 0;

const advertPopup = document.getElementById('advertPopup');
const advertImg = document.getElementById('advertImg');
const advertDesc = document.getElementById('advertDesc');
const advertPrice = document.getElementById('advertPrice');
const advertLocation = document.getElementById('advertLocation');
const viewBtn = document.getElementById('viewAdvertBtn');
const closeBtn = document.querySelector('#advertPopup .close-btn');

function showAdvert(index){
    if(!adverts.length) return;

    const advert = adverts[index];

    advertImg.src = advert.property_image;
    advertDesc.innerHTML = "<strong>Description:</strong> " + advert.description;
    advertPrice.innerHTML = "<strong>Price:</strong> ₦" + parseFloat(advert.price).toLocaleString('en-NG', { minimumFractionDigits: 2, maximumFractionDigits: 2 });

    advertLocation.innerHTML = "<strong>Location:</strong> " + advert.prop_location;
    viewBtn.href = "view_adverts.php?property_id=" + advert.property_id;

    advertPopup.style.display = "block";
    advertPopup.style.animation = "slideInLeft 0.8s forwards";
    advertPopup.classList.add('pulse');

    // Auto slide out after 3 seconds
    setTimeout(() => {
        advertPopup.style.animation = "slideOutLeft 0.8s forwards";
        advertPopup.classList.remove('pulse');
    }, 3000);
}

// Close button
closeBtn.addEventListener('click', () => {
    advertPopup.style.display = "none";
    advertPopup.classList.remove('pulse');
});

// Cycle adverts every 12 seconds
function cycleAdverts(){
    showAdvert(currentIndex);
    currentIndex = (currentIndex + 1) % adverts.length;
    setTimeout(cycleAdverts, 12000);
}

window.addEventListener('load', () => {
    if(adverts.length) cycleAdverts();
});
</script>


<!--- End here ----->


<section id="counters" class="py-5" style="background:#0d1117; opacity:0; transform: translateY(50px); transition: all 1s ease;">
  <div class="container">
   <!-- <h2 class="text-center text-white fw-bold mb-5">Our Impact</h2> -->
    <div class="row row-cols-1 row-cols-md-3 row-cols-lg-5 g-4 text-center">

      <div class="col">
        <div class="card counter-card bg-primary text-white p-4 shadow-sm">
          <i class="fas fa-house fa-2x mb-2"></i>
          <h3 class="counter" data-target="1245">0</h3>
          <p>Rental Properties</p>
        </div>
      </div>

      <div class="col">
        <div class="card counter-card bg-success text-white p-4 shadow-sm">
          <i class="fas fa-building fa-2x mb-2"></i>
          <h3 class="counter" data-target="876">0</h3>
          <p>Estate Properties</p>
        </div>
      </div>

      <div class="col">
        <div class="card counter-card bg-warning text-white p-4 shadow-sm">
          <i class="fas fa-home fa-2x mb-2"></i>
          <h3 class="counter" data-target="540">0</h3>
          <p>Houses for Sale</p>
        </div>
      </div>

      <div class="col">
        <div class="card counter-card bg-danger text-white p-4 shadow-sm">
          <i class="fas fa-tree fa-2x mb-2"></i>
          <h3 class="counter" data-target="312">0</h3>
          <p>Lands for Sale</p>
        </div>
      </div>

      <div class="col">
        <div class="card counter-card bg-purple text-white p-4 shadow-sm">
          <i class="fas fa-user-check fa-2x mb-2"></i>
          <h3 class="counter" data-target="85">0</h3>
          <p>Verified Agents</p>
        </div>
      </div>

    </div>
  </div>

  <style>
    .counter-card {
      border-radius: 12px;
      transition: transform 0.3s;
    }
    .counter-card:hover {
      transform: translateY(-5px);
    }
    .bg-purple { background-color: #845ef7 !important; }
    .counter { font-size: 2rem; font-weight: 700; margin-bottom:0.3rem; }
    .counter + p { margin-bottom: 0; font-weight: 500; }
    .counter sup {
      font-size: 0.7em;
      vertical-align: super;
    }
  </style>

  <script>
    const counters = document.querySelectorAll('.counter');
    let countersStarted = false;

    function startCounters() {
      if (countersStarted) return;
      countersStarted = true;

      counters.forEach((counter, index) => {
        const target = +counter.getAttribute('data-target');
        let count = 0;
        const duration = 3000;
        const stepTime = Math.ceil(duration / target);

        setTimeout(() => {
          const updateCounter = setInterval(() => {
            count++;
            if (count >= target) {
              clearInterval(updateCounter);
              counter.innerHTML = target + '<sup>+</sup>';
            } else {
              counter.innerText = count;
            }
          }, stepTime);
        }, index * 300); // stagger each counter by 0.3s
      });
    }

    // Animate section on scroll into view
    const counterSection = document.getElementById('counters');
    const observer = new IntersectionObserver(entries => {
      entries.forEach(entry => {
        if(entry.isIntersecting){
          counterSection.style.opacity = '1';
          counterSection.style.transform = 'translateY(0)';
          startCounters();
        }
      });
    }, { threshold: 0.5 });

    observer.observe(counterSection);
  </script>
</section>

  <!-- Categories -->
<section id="categories" class="container py-5">
  <h2 class="text-center fw-bold mb-5">Property Categories</h2>

  <div class="row g-4">
    <!-- Rental Properties -->
    <div class="col-md-3 col-sm-6">
      <div class="card category-card shadow-sm h-100 text-center position-relative">
        <img src="images/rent.webp" class="card-img-top" alt="Rental Properties">
        <div class="icon-overlay"><i class="fas fa-home"></i></div>
        <div class="card-body">
          <h5 class="card-title">Rental Properties</h5>
          <button class="btn btn-primary btn-sm view-btn">View</button>
        </div>
      </div>
    </div>

    <!-- Estate Plots -->
    <div class="col-md-3 col-sm-6">
      <div class="card category-card shadow-sm h-100 text-center position-relative">
        <img src="images/est.jpeg" class="card-img-top" alt="Estate Plots">
        <div class="icon-overlay"><i class="fas fa-landmark"></i></div>
        <div class="card-body">
          <h5 class="card-title">Premium Estate Plots</h5>
          <button class="btn btn-primary btn-sm view-btn" data-target="#admin-properties">View</button>
        </div>
      </div>
    </div>

    <!-- Houses for Sale -->
    <div class="col-md-3 col-sm-6">
      <div class="card category-card shadow-sm h-100 text-center position-relative">
        <img src="images/house.jpg" class="card-img-top" alt="Houses for Sale">
        <div class="icon-overlay"><i class="fas fa-building"></i></div>
        <div class="card-body">
          <h5 class="card-title">Houses for Sale</h5>
          <button class="btn btn-primary btn-sm view-btn">View</button>
        </div>
      </div>
    </div>

    <!-- Lands for Sale -->
    <div class="col-md-3 col-sm-6">
      <div class="card category-card shadow-sm h-100 text-center position-relative">
        <img src="images/land.jpeg" class="card-img-top" alt="Lands for Sale">
        <div class="icon-overlay"><i class="fas fa-tree"></i></div>
        <div class="card-body">
          <h5 class="card-title">Lands for Sale</h5>
          <button class="btn btn-primary btn-sm view-btn">View</button>
        </div>
      </div>
    </div>
  </div>

  <!-- FontAwesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <style>
    #categories {
      background-color: #f3f6f9;
      border-radius: 12px;
      padding: 40px 20px;
      opacity: 0;
      transform: translateY(40px) scale(0.95);
      transition: all 0.8s ease-in-out;
    }
    #categories.visible {
      opacity: 1;
      transform: translateY(0) scale(1);
    }
    .category-card {
      opacity: 0;
      transform: translateY(40px);
      transition: all 0.7s ease;
    }
    .category-card.visible {
      opacity: 1;
      transform: translateY(0);
    }
    .category-card img {
      height: 180px;
      object-fit: cover;
      border-radius: 8px;
    }
    .category-card:hover {
      transform: translateY(-5px);
      transition: transform 0.3s;
    }
    .view-btn {
      margin-top: 10px;
    }
    .icon-overlay {
      position: absolute;
      top: 10px;
      left: 10px;
      background: rgba(255,255,255,0.9);
      color: #007bff;
      padding: 10px;
      border-radius: 50%;
      font-size: 20px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    }
  </style>

  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // Smooth scroll for buttons
      document.querySelectorAll('.view-btn').forEach(btn => {
        btn.addEventListener('click', function(e) {
          e.preventDefault();
          const targetSelector = this.getAttribute('data-target') || '#properties';
          const target = document.querySelector(targetSelector);
          if (target) {
            target.scrollIntoView({ behavior: 'smooth', block: 'start' });
          }
        });
      });

      // Intersection Observer with staggered animation
      const cards = document.querySelectorAll('.category-card');
      const section = document.querySelector('#categories');

      const observer = new IntersectionObserver(entries => {
        entries.forEach(entry => {
          if (entry.isIntersecting) {
            // Animate section
            if (entry.target.id === 'categories') {
              entry.target.classList.add('visible');
            }
            // Animate cards with delay
            if (entry.target.classList.contains('category-card')) {
              const index = [...cards].indexOf(entry.target);
              setTimeout(() => {
                entry.target.classList.add('visible');
              }, index * 200); // 200ms stagger
            }
          }
        });
      }, { threshold: 0.2 });

      if (section) observer.observe(section);
      cards.forEach(card => observer.observe(card));
    });
  </script>
</section>


  <!-- Call to Action -->
<section id="cta" class="py-5 pulse-section" style="background: #000;">
  <div class="container">
    <div class="row align-items-center">
      
      <!-- Left: Image -->
      <div class="col-md-5 text-center mb-4 mb-md-0">
        <img src="images/limac.jpeg" 
             alt="Join Limac Groups" 
             class="img-fluid rounded shadow"
             style="max-height: 250px; width: auto; object-fit: contain;">
      </div>

      <!-- Right: Text & CTA -->
      <div class="col-md-7">
        <h2 class="fw-bold mb-3 cta-heading">Become an Agent on Limac Groups – 100% Free</h2>
        <ul class="list-unstyled mb-4">
          <li class="mb-2 text-white">
            <i class="fas fa-home text-primary me-2"></i> List unlimited properties for free
          </li>
          <li class="mb-2 text-white">
            <i class="fas fa-bullhorn text-success me-2"></i> Post adverts and boost visibility
          </li>
          <li class="mb-2 text-white">
            <i class="fas fa-users text-warning me-2"></i> Reach potential buyers & renters directly
          </li>
          <li class="mb-2 text-white">
            <i class="fas fa-chart-line text-danger me-2"></i> Manage everything in your agent dashboard
          </li>
        </ul>
        <a href="#subscription" class="btn btn-lg pulse-btn">Start Free Today</a>
      </div>

    </div>
  </div>

  <!-- Scoped CSS -->
  <style>
    /* Section pulse: background color + scale */
    @keyframes pulse-section {
      0% { transform: scale(1); background-color: #000; box-shadow: 0 0 0 rgba(0,0,0,0.3); }
      50% { transform: scale(1.02); background-color: #004d4d; box-shadow: 0 0 25px rgba(0,128,128,0.6); }
      100% { transform: scale(1); background-color: #000; box-shadow: 0 0 0 rgba(0,0,0,0.3); }
    }

    .pulse-section {
      animation: pulse-section 4s infinite;
      border-radius: 15px;
      transition: background-color 0.5s ease;
    }

    /* CTA button pulse: color + scale */
    @keyframes pulse-btn {
      0% { transform: scale(1); background-color: #0d6efd; box-shadow: 0 0 0 rgba(13,110,253,0.4); }
      50% { transform: scale(1.08); background-color: #ff6600; box-shadow: 0 0 20px rgba(255,102,0,0.7); }
      100% { transform: scale(1); background-color: #0d6efd; box-shadow: 0 0 0 rgba(13,110,253,0.4); }
    }

    .pulse-btn {
      animation: pulse-btn 3s infinite;
      color: #fff;
      font-weight: bold;
      border: none;
      transition: background-color 0.3s ease;
    }

    /* Optional: add subtle hover effect on button */
    .pulse-btn:hover {
      transform: scale(1.1);
    }
  </style>
</section>


<section id="property-search" class="container py-5">
  <h4 class="mb-4 text-center">Search Properties</h4>
  <form method="GET" action="search_results.php" class="row g-3 justify-content-center mb-5">
    
    <div class="col-md-3">
      <select name="type" class="form-select">
        <option value="">All Types</option>
        <option value="sale">Sale</option>
        <option value="rent">Rental</option>
      </select>
    </div>

    <div class="col-md-3">
      <select name="location" class="form-select">
        <option value="">All Locations</option>
        <?php
        require_once "config.php";
        $loc_res = $conn->query("SELECT DISTINCT location FROM properties ORDER BY location ASC");
        while($loc = $loc_res->fetch_assoc()) {
            echo '<option value="'.htmlspecialchars($loc['location']).'">'.htmlspecialchars($loc['location']).'</option>';
        }
        ?>
      </select>
    </div>

    <!--<div class="col-md-2">
      <input type="number" name="min_price" class="form-control" placeholder="Min Price">
    </div>

    <div class="col-md-2">
      <input type="number" name="max_price" class="form-control" placeholder="Max Price">
    </div> -->

    <div class="col-md-2 d-grid">
      <button type="submit" class="btn btn-primary">Search</button>
    </div>
  </form>
</section>


  <!-- Properties (rentals & sales) -->
<section id="properties" class="container py-5">
  <h4 class="mb-4">Properties - Sales & Rentals</h4>

  <!-- Filter Buttons -->
  <div class="mb-4 d-flex gap-2 flex-wrap">
    <button class="btn btn-outline-primary active filter-btn" data-filter="all">All</button>
    <button class="btn btn-outline-primary filter-btn" data-filter="sale">Sale</button>
    <button class="btn btn-outline-primary filter-btn" data-filter="rent">Rental</button>
  </div>

  <!-- Properties Grid -->
  <div id="propertiesContainer" class="row g-4">
    <?php
 require_once "config.php";

  // Fetch random properties
 $res = $conn->query("
  SELECT p.*, 
    (SELECT GROUP_CONCAT(image_path SEPARATOR ',') FROM property_images WHERE property_id = p.id) AS images
  FROM properties p
  ORDER BY RAND()
  LIMIT 10  -- optional: limit to 10 random properties
  ");

 while ($prop = $res->fetch_assoc()):
    // Guard against empty images string
    $images = [];
    if (!empty($prop['images'])) {
        $images = explode(',', $prop['images']);
    } else {
        $images = ['images/placeholder.jpg']; // fallback
    }

    $badge = ($prop['type'] === 'sale') ? 'Sale' : 'Rental';
 ?>
      <div class="col-12 col-sm-6 col-md-4 col-lg-3 col-xl-2 property-card d-flex" data-type="<?= htmlspecialchars($prop['type']) ?>">
        <div class="card shadow-sm flex-fill d-flex flex-column">
          <div class="position-relative">
            <div id="carousel<?= $prop['id'] ?>" class="carousel slide" data-bs-ride="carousel">
              <div class="carousel-inner">
                <?php foreach ($images as $i => $img): ?>
                  <div class="carousel-item <?= $i === 0 ? 'active' : '' ?>">
                    <img src="<?= htmlspecialchars($img) ?>" class="d-block w-100 property-img" alt="Property Image">
                  </div>
                <?php endforeach; ?>
              </div>
              <?php if(count($images) > 1): ?>
                <button class="carousel-control-prev" type="button" data-bs-target="#carousel<?= $prop['id'] ?>" data-bs-slide="prev">
                  <span class="carousel-control-prev-icon"></span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#carousel<?= $prop['id'] ?>" data-bs-slide="next">
                  <span class="carousel-control-next-icon"></span>
                </button>
              <?php endif; ?>
            </div>
            <span class="badge bg-success position-absolute top-0 end-0 m-2 p-2"><?= $badge ?></span>
          </div>
          <div class="card-body d-flex flex-column mt-2">
            <h5 class="card-title"><?= htmlspecialchars($prop['title']) ?></h5>
            <p class="card-text"><?= htmlspecialchars(substr($prop['description'],0,60)) ?>...</p>
            <p class="mb-1 mt-auto">
              <strong>Price:</strong> ₦<?= number_format($prop['type']==='rent' ? $prop['total_package'] : $prop['price']) ?>
            </p>
            <p class="mb-2"><strong>Location:</strong> <?= htmlspecialchars($prop['location']) ?></p>
            <a href="view_details.php?id=<?= $prop['id'] ?>" class="btn btn-primary btn-sm mt-2">View Details</a>
          </div>
        </div>
      </div>
    <?php endwhile; ?>
  </div>

  <!-- Scoped CSS -->
  <style>
    /* Make properties container scrollable vertically */
#propertiesContainer {
    max-height: 900px;  /* adjust height as needed */
    overflow-y: auto;
    padding-right: 5px; /* avoid content cutoff due to scrollbar */
}


/* Center h4 and filter buttons */
#properties h4,
#properties .mb-4.d-flex {
    text-align: center;
    justify-content: center;
}

/* Keep 4 cards in a row on desktop (using col-lg-3) */
#propertiesContainer .property-card {
    flex: 0 0 auto; /* let Bootstrap handle width via col-* */
}

/* Responsive for smaller screens: 2 columns visible */
@media (max-width: 991px) {
    #propertiesContainer .property-card {
        flex: 0 0 48%; /* roughly 2 columns */
        max-width: 48%;
    }
}

@media (max-width: 575px) {
    #propertiesContainer .property-card {
        flex: 0 0 100%; /* 1 column on mobile */
        max-width: 100%;
    }
}

    /* keep styles scoped to #properties */
    #properties {
    background-color: #f8f9fa; /* change to any color you want */
    }
    /* Wider property cards with adjustable pixel width */
  #properties #propertiesContainer .property-card {
    flex: 0 0 293px; /* adjust this width as you like */
    max-width: 293px;
    margin-bottom: 1rem; /* space between rows */
  }

  /* Keep the card responsive for smaller screens */
  @media (max-width: 1199px) {
    #properties #propertiesContainer .property-card {
        flex: 0 0 200px;
        max-width: 200px;
    }
  }

  @media (max-width: 991px) {
    #properties #propertiesContainer .property-card {
        flex: 0 0 45%;
        max-width: 45%;
    }
  }

  @media (max-width: 575px) {
    #properties #propertiesContainer .property-card {
        flex: 0 0 100%;
        max-width: 100%;
    }
 }


    #properties .property-card { display: flex; transition: opacity .18s ease, transform .18s ease; }
    #properties .property-card .card { display: flex; flex-direction: column; flex: 1 1 auto; height: 100%; }
    #properties .property-img { height: 200px; object-fit: cover; width: 100%; }
    #properties .badge { font-size: 0.8rem; }
    #properties .filter-btn.active { background-color: #0d6efd; color: #fff; border-color: #0d6efd; }
    /* small helper to ensure hidden elements are definitely not visible */
    #properties .property-card.d-none { display: none !important; }

  </style>

  <!-- Scoped JS -->
  <script>
    (function () {
      const section = document.getElementById('properties');
      if (!section) return;

      const buttons = Array.from(section.querySelectorAll('.filter-btn'));
      const cards = Array.from(section.querySelectorAll('.property-card'));

      const normalize = v => (v || '').toString().trim().toLowerCase();

      // animation-friendly show/hide
      function showCard(card) {
        card.classList.remove('d-none');
        // force reflow so transition happens
        void card.offsetWidth;
        card.style.opacity = '1';
        card.style.transform = 'translateY(0)';
      }

      function hideCard(card) {
        // fade out then add d-none so layout doesn't jump
        card.style.opacity = '0';
        card.style.transform = 'translateY(6px)';
        setTimeout(() => {
          // only add d-none if still supposed to be hidden
          if (card.style.opacity === '0') card.classList.add('d-none');
        }, 180);
      }

      function applyFilter(filterType) {
        filterType = normalize(filterType);
        cards.forEach(card => {
          const t = normalize(card.dataset.type);
          if (filterType === 'all' || t === filterType) {
            showCard(card);
          } else {
            hideCard(card);
          }
        });
      }

      // event delegation: capture clicks on any filter button
      section.addEventListener('click', (e) => {
        const btn = e.target.closest('.filter-btn');
        if (!btn) return;
        e.preventDefault();

        // manage active class
        buttons.forEach(b => b.classList.remove('active'));
        btn.classList.add('active');

        applyFilter(btn.getAttribute('data-filter'));
      });

      // initialize: ensure transition starting state
      cards.forEach(c => {
        c.style.opacity = '1';
        c.style.transform = 'translateY(0)';
      });

      // apply initial filter (from .active button or 'all')
      const active = section.querySelector('.filter-btn.active');
      applyFilter(active ? active.getAttribute('data-filter') : 'all');

      // helpful debug (remove in production if you like)
      // console.log('Property filter initialized', { buttonCount: buttons.length, cardCount: cards.length });
    })();
  </script>
</section>




<section id="hot-deals" class="py-5 text-center text-white position-relative overflow-hidden">
  <style>
    /* Section background & pulse */
    #hot-deals {
      background: linear-gradient(135deg, #ff6b6b, #f06595, #f8c291);
      background-size: 400% 400%;
      padding: 5rem 1rem;
      border-radius: 15px;
      position: relative;
      overflow: hidden;
      animation: gradientShift 15s ease infinite, sectionPulse 6s ease-in-out infinite;
    }

    /* Floating particles / spark trails */
    #hot-deals .particle {
      position: absolute;
      border-radius: 50%;
      pointer-events: none;
      animation: floatTrail 6s linear infinite;
      filter: blur(2px);
    }

    @keyframes floatTrail {
      0% { transform: translateY(0) scale(0.5); opacity: 1; }
      50% { opacity: 0.6; }
      100% { transform: translateY(-300px) scale(0); opacity: 0; }
    }

    /* Gradient background animation */
    @keyframes gradientShift {
      0% { background-position: 0% 50%; }
      50% { background-position: 100% 50%; }
      100% { background-position: 0% 50%; }
    }

    /* Section pulse */
    @keyframes sectionPulse {
      0% { transform: scale(1); }
      50% { transform: scale(1.02); }
      100% { transform: scale(1); }
    }

    /* Badge styling and pulse */
    #hot-deals .badge {
      font-weight: 600;
      letter-spacing: 0.5px;
      padding: 0.6rem 1.2rem;
      font-size: 1rem;
      opacity: 0;
      animation: fadeInDown 1s forwards 0.3s, badgePulse 2s ease-in-out infinite 1.5s;
      display: inline-block;
      text-shadow: 0 0 8px rgba(255,255,255,0.5);
    }

    @keyframes badgePulse {
      0%, 100% { transform: scale(1); box-shadow: 0 0 0 rgba(255,255,0,0); }
      50% { transform: scale(1.1); box-shadow: 0 0 15px rgba(255,255,0,0.6); }
    }

    /* Title and description */
    #hot-deals h2 {
      font-size: 2.5rem;
      font-weight: 700;
      margin-bottom: 1rem;
      opacity: 0;
      animation: fadeInUp 1s forwards 0.6s, floatText 4s ease-in-out infinite;
      text-shadow: 0 0 8px rgba(255,255,255,0.5);
    }

    #hot-deals p {
      font-size: 1.1rem;
      margin-bottom: 2rem;
      opacity: 0;
      animation: fadeInUp 1s forwards 0.9s, floatText 4s ease-in-out infinite;
      text-shadow: 0 0 6px rgba(255,255,255,0.3);
    }

    @keyframes floatText {
      0%, 100% { transform: translateY(0); }
      50% { transform: translateY(-5px); }
    }

    /* Button */
    #hot-deals .btn {
      font-size: 1.2rem;
      padding: 0.75rem 2rem;
      transition: transform 0.3s, box-shadow 0.3s, background-color 0.3s;
      opacity: 0;
      animation: fadeInUp 1s forwards 1.2s, btnPulse 3s ease-in-out infinite 1.5s;
      text-shadow: 0 0 6px rgba(0,0,0,0.3);
    }

    @keyframes btnPulse {
      0%, 100% { transform: scale(1); box-shadow: 0 0 0 rgba(255,255,255,0.2); }
      50% { transform: scale(1.05); box-shadow: 0 0 20px rgba(255,255,255,0.5); }
    }

    #hot-deals .btn:hover {
      transform: scale(1.1);
      box-shadow: 0 8px 25px rgba(255,255,255,0.7);
      background-color: #ffd700;
      color: #000;
    }

    /* Fade animations */
    @keyframes fadeInUp {
      0% { opacity: 0; transform: translateY(20px); }
      100% { opacity: 1; transform: translateY(0); }
    }
    @keyframes fadeInDown {
      0% { opacity: 0; transform: translateY(-20px); }
      100% { opacity: 1; transform: translateY(0); }
    }

    /* Diagonal light streaks */
    #hot-deals::before, #hot-deals::after {
      content: '';
      position: absolute;
      top: -50%;
      left: -50%;
      width: 200%;
      height: 200%;
      background: linear-gradient(45deg, rgba(255,255,255,0.15) 0%, rgba(255,255,255,0) 60%);
      transform: rotate(25deg);
      animation: streakMove 10s linear infinite;
      pointer-events: none;
    }
    #hot-deals::after {
      transform: rotate(-25deg);
      animation-delay: 5s;
    }

    @keyframes streakMove {
      0% { transform: translateX(-100%) rotate(25deg); }
      100% { transform: translateX(100%) rotate(25deg); }
    }

    /* Responsive */
    @media (max-width: 768px) {
      #hot-deals h2 { font-size: 2rem; }
      #hot-deals p { font-size: 1rem; }
      #hot-deals .btn { font-size: 1rem; padding: 0.65rem 1.5rem; }
    }
  </style>

  <div class="container position-relative">
    <span class="badge bg-warning text-dark">HOT DEALS</span>
    <h2>Ongoing Sales at Discounted Rates</h2>
    <p>Discover amazing property deals and discounted packages waiting for you. Don't miss out!</p>
    <a href="#admin-properties" class="btn btn-light shadow-sm">View Hot Deals</a>
  </div>

  <!-- Dynamic particles -->
  <script>
    const section = document.getElementById('hot-deals');
    const particleCount = 50;
    const colors = ['#fff', '#ffd700', '#ff6b6b', '#f06595', '#f8c291'];

    for(let i=0; i<particleCount; i++){
      const particle = document.createElement('div');
      particle.classList.add('particle');
      particle.style.left = Math.random() * 100 + '%';
      particle.style.top = Math.random() * 100 + '%';
      const size = 3 + Math.random() * 8;
      particle.style.width = size + 'px';
      particle.style.height = size + 'px';
      particle.style.background = colors[Math.floor(Math.random() * colors.length)];
      particle.style.opacity = Math.random();
      particle.style.animationDuration = 3 + Math.random() * 5 + 's';
      particle.style.animationDelay = Math.random() * 5 + 's';
      section.appendChild(particle);

      setInterval(() => {
        particle.style.background = colors[Math.floor(Math.random() * colors.length)];
      }, 2000 + Math.random() * 3000);
    }
  </script>
</section>



<?php
require_once "config.php";

// Fetch admin properties
$admin_props_res = $conn->query("SELECT * FROM admin_properties ORDER BY id DESC");
$admin_props = [];
if($admin_props_res && $admin_props_res->num_rows > 0){
    while($prop = $admin_props_res->fetch_assoc()){
        $admin_props[] = $prop;
    }
}
?>

<?php if(!empty($admin_props)): ?>
<section id="admin-properties" class="py-5" style="background:#e0f7f1; transition: background 0.5s;">
  <div class="container">
    <h4 class="mb-4 text-center">Premium Estate Properties</h4>

    <!-- Filter buttons -->
<div class="text-center mb-4">
  <button class="btn btn-outline-primary filter-btn active" data-filter="all">All</button>
  <button class="btn btn-outline-primary filter-btn" data-filter="estate">Estate properties</button>
  <button class="btn btn-outline-primary filter-btn" data-filter="sale">Luxury properties</button>
</div>

    <div class="carousel-container position-relative">
      <!-- Horizontal scroll container -->
      <div class="properties-scroll d-flex gap-3 pb-2">
        <?php foreach($admin_props as $prop):
            $extra_images = $prop['images'] ? explode(',', $prop['images']) : [];
            $main_img = $prop['property_image'] ?? 'placeholder.jpg';
        ?>
        <div class="card property-card flex-shrink-0 <?= strtolower($prop['property_type']) ?>">

          <img src="<?= htmlspecialchars($main_img) ?>" class="card-img-top" alt="Property Image">
          <div class="card-body d-flex flex-column justify-content-between">
            <p class="mb-1"><strong>Type:</strong> <?= htmlspecialchars(ucfirst($prop['property_type'])) ?></p>
            <p class="mb-1"><strong>Price:</strong> ₦<?= number_format($prop['price'],2) ?></p>
            <p class="mb-1"><strong>Location:</strong> <?= htmlspecialchars($prop['location']) ?></p>
            <button class="btn btn-primary mt-auto" data-bs-toggle="modal" data-bs-target="#viewPropertyModal<?= $prop['id'] ?>">View Details</button>
          </div>
        </div>

        <!-- Property Modal -->
        <div class="modal fade" id="viewPropertyModal<?= $prop['id'] ?>" tabindex="-1" aria-labelledby="viewPropertyModalLabel<?= $prop['id'] ?>" aria-hidden="true">
          <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="viewPropertyModalLabel<?= $prop['id'] ?>">Property Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
              </div>
              <div class="modal-body">
                <img src="<?= htmlspecialchars($main_img) ?>" class="img-fluid mb-3" alt="Property Image">

                <?php if(!empty($extra_images)): ?>
                <div class="mb-3 d-flex flex-wrap gap-2">
                  <?php foreach($extra_images as $img): ?>
                  <img src="<?= htmlspecialchars($img) ?>" style="width:80px; height:80px; object-fit:cover; border-radius:4px;" alt="Extra Image">
                  <?php endforeach; ?>
                </div>
                <?php endif; ?>

                <?php if(!empty($prop['video'])): ?>
                <div class="mb-3">
                  <video controls style="width:100%; max-height:400px; border-radius:6px;">
                    <source src="<?= htmlspecialchars($prop['video']) ?>" type="video/mp4">
                    Your browser does not support the video tag.
                  </video>
                </div>
                <?php endif; ?>

                <p><strong>Description:</strong></p>
                <p><?= nl2br(htmlspecialchars($prop['description'])) ?></p>
                <p><small class="text-muted">Uploaded: <?= date('d M Y', strtotime($prop['created_at'])) ?></small></p>
              </div>
              <div class="modal-footer">
                <!-- Close Button -->
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <!-- Book Inspection triggers the inspection modal -->
                <button type="button" class="btn btn-primary book-btn" data-bs-toggle="modal" data-bs-target="#inspectionModal" data-prop="<?= $prop['id'] ?>">Book Inspection</button>
              </div>
            </div>
          </div>
        </div>

        <?php endforeach; ?>
      </div>

      <!-- Carousel navigation buttons -->
      <button class="carousel-nav prev">&lt;</button>
      <button class="carousel-nav next">&gt;</button>
    </div>
  </div>
</section>

<!-- Book Inspection Modal -->
<div class="modal fade" id="inspectionModal" tabindex="-1" aria-labelledby="inspectionModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form action="process_inspection.php" method="POST">
        <div class="modal-header">
          <h5 class="modal-title" id="inspectionModalLabel">Book Inspection</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="property_id" id="modal_property_id">
          <div class="mb-3">
            <label>Name</label>
            <input type="text" class="form-control" name="name" required>
          </div>
          <div class="mb-3">
            <label>Phone</label>
            <input type="text" class="form-control" name="phone" required>
          </div>
          <div class="mb-3">
            <label>Email (optional)</label>
            <input type="email" class="form-control" name="email">
          </div>
          <div class="mb-3">
            <label>Preferred Date</label>
            <input type="date" class="form-control" name="inspection_date" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success">Submit Inspection Request</button>
        </div>
      </form>
    </div>
  </div>
</div>

<style>
/* Carousel container */
.carousel-container { position: relative; }
.properties-scroll { overflow: hidden; display: flex; gap: 1rem; scroll-behavior: smooth; transition: transform 0.5s; }

/* Property card */
.property-card { min-width: 250px; max-width: 250px; flex-shrink: 0; display: flex; flex-direction: column; }
.property-card img { height: 180px; object-fit: cover; }
.property-card:hover { transform: scale(1.03); transition: 0.2s; }

/* Carousel navigation buttons */
.carousel-nav {
  position: absolute; top: 50%; transform: translateY(-50%);
  background: rgba(0,0,0,0.5); border: none; color: #fff;
  padding: 0.5rem 1rem; cursor: pointer; border-radius: 4px; z-index:2;
}
.carousel-nav.prev { left: 0; }
.carousel-nav.next { right: 0; }

/* Responsive adjustments */
@media(max-width: 1199px) { .property-card { min-width: 200px; max-width: 200px; } }
@media(max-width: 991px) { .property-card { min-width: 180px; max-width: 180px; } }
@media(max-width: 767px) { .property-card { min-width: 80%; max-width: 80%; } }
/* Ensure modal is always on top */
.modal { z-index: 1055 !important; }
</style>

<script>
document.addEventListener('DOMContentLoaded', function(){
  // Book Inspection Modal property id
  document.querySelectorAll('.book-btn').forEach(btn => {
    btn.addEventListener('click', function(){
      const propId = this.getAttribute('data-prop');
      document.getElementById('modal_property_id').value = propId;
    });
  });

  // Carousel Auto Slide
  const container = document.querySelector('.properties-scroll');
  const cards = container.querySelectorAll('.property-card');
  const prevBtn = document.querySelector('.carousel-nav.prev');
  const nextBtn = document.querySelector('.carousel-nav.next');
  let currentIndex = 0;
  const cardWidth = cards[0].offsetWidth + 16; // width + gap
  const visibleCards = window.innerWidth >= 992 ? 3 : 1;

  function slideTo(index){
    container.scrollTo({ left: index * cardWidth, behavior: 'smooth' });
  }

  function next(){ currentIndex++; if(currentIndex > cards.length - visibleCards) currentIndex = 0; slideTo(currentIndex); }
  function prev(){ currentIndex--; if(currentIndex < 0) currentIndex = cards.length - visibleCards; slideTo(currentIndex); }

  let interval = setInterval(next, 4000);

  nextBtn.addEventListener('click', ()=>{ next(); resetInterval(); });
  prevBtn.addEventListener('click', ()=>{ prev(); resetInterval(); });

  function resetInterval(){
    clearInterval(interval);
    interval = setInterval(next, 4000);
  }
});
</script>
<script>
document.addEventListener('DOMContentLoaded', function(){
  const filterBtns = document.querySelectorAll('.filter-btn');
  const cards = document.querySelectorAll('.property-card');

  filterBtns.forEach(btn => {
    btn.addEventListener('click', function(){
      filterBtns.forEach(b => b.classList.remove('active'));
      this.classList.add('active');

      const filter = this.getAttribute('data-filter');
      cards.forEach(card => {
        if(filter === 'all' || card.classList.contains(filter)){
          card.style.display = 'flex';
        } else {
          card.style.display = 'none';
        }
      });
    });
  });
});
</script>
<?php endif; ?>


  <!-- Adverts / Promoted Listings -->
<?php
require_once "config.php";

// Fetch active homepage adverts
$adverts_res = $conn->query("
    SELECT a.*, p.title, p.type, p.price, p.total_package, p.description, p.location,
    (SELECT image_path FROM property_images WHERE property_id=p.id LIMIT 1) AS image
    FROM adverts a
    JOIN properties p ON a.property_id = p.id
    WHERE a.status='active' AND a.location='homepage'
    ORDER BY a.created_at DESC
");
$adverts = [];
if($adverts_res && $adverts_res->num_rows > 0){
    while($adv = $adverts_res->fetch_assoc()){
        $adverts[] = $adv;
    }
}
?>

<?php if(!empty($adverts)): ?>
<section id="adverts" class="py-5">
  <div class="container text-center">
    <h4 class="mb-4">Featured Listings</h4>

    <div class="fade-slider position-relative mx-auto">
      <?php 
      $effects = ['slide-left', 'slide-right', 'zoom-in', 'flip'];
      foreach($adverts as $index => $adv): 
        $price = $adv['type']==='rent' ? $adv['total_package'] : $adv['price'];
        $badge = $adv['type'] === 'sale' ? 'Sale' : 'Rental';
        $desc = substr($adv['description'],0,40).'...'; 
        $img = $adv['image'] ?? 'placeholder.jpg';
        $effect = $effects[array_rand($effects)]; // random effect each reload
      ?>
        <div class="fade-slide <?= $effect ?> <?= $index===0 ? 'active' : '' ?>">
          <div class="card shadow-sm mx-auto advert-card">
            <span class="badge bg-success position-absolute top-0 start-0 m-3 px-3 py-2 fs-6"><?= $badge ?></span>
            <img src="<?= htmlspecialchars($img) ?>" class="card-img-top" alt="Advert">
            <div class="card-body d-flex flex-column justify-content-between">
              <div>
                <h6 class="card-title"><?= htmlspecialchars($adv['type']) ?></h6>
                <p class="mb-1"><strong>Price:</strong> ₦<?= number_format($price) ?></p>
                <p class="card-text"><?= htmlspecialchars($desc) ?></p>
                <p class="mb-2"><strong>Location:</strong> <?= htmlspecialchars($adv['location']) ?></p>
              </div>
              <a href="view_details.php?id=<?= $adv['property_id'] ?>" class="btn btn-primary mt-2">View Details</a>
            </div>
          </div>
        </div>
      <?php endforeach; ?>

      <?php if(count($adverts) > 1): ?>
        <button class="fade-prev">&lt;</button>
        <button class="fade-next">&gt;</button>
      <?php endif; ?>
    </div>
  </div>

  <!-- Slider JS -->
  <script>
  document.addEventListener('DOMContentLoaded', function(){
    const slides = document.querySelectorAll('#adverts .fade-slide');
    const prevBtn = document.querySelector('.fade-prev');
    const nextBtn = document.querySelector('.fade-next');
    let index = 0;
    const total = slides.length;

    function showSlide(i){
      slides.forEach((s, idx) => {
        s.classList.remove('active');
        if(idx === i) s.classList.add('active');
      });
    }

    function nextSlide(){ index = (index + 1) % total; showSlide(index); }
    function prevSlide(){ index = (index - 1 + total) % total; showSlide(index); }

    let autoSlide = setInterval(nextSlide, 4000);

    if(nextBtn) nextBtn.addEventListener('click', () => { nextSlide(); resetInterval(); });
    if(prevBtn) prevBtn.addEventListener('click', () => { prevSlide(); resetInterval(); });

    function resetInterval(){
      clearInterval(autoSlide);
      autoSlide = setInterval(nextSlide, 4000);
    }

    showSlide(index);
  });
  </script>

  <!-- Slider CSS -->
  <style>
  #adverts {
    background: linear-gradient(135deg, #f8f9fa, #eef3f7);
  }
  #adverts h4 {
    font-weight: 600;
    color: #333;
  }

  /* Slider container */
  #adverts .fade-slider {
    position: relative;
    margin: 0 auto;
    overflow: hidden;
    max-width: 520px;
    height: 480px;
    border-radius: 15px;
    box-shadow: 0 8px 18px rgba(0,0,0,0.1);
    background: #fff;
  }

  /* Slides */
  #adverts .fade-slide {
    position: absolute;
    inset: 0;
    opacity: 0;
    display: flex;
    justify-content: center;
  }
  #adverts .fade-slide.active {
    opacity: 1;
    z-index: 1;
  }

  /* Animations */
  .fade-slide.slide-left.active {
    animation: slideLeftIn 0.8s ease forwards;
  }
  .fade-slide.slide-right.active {
    animation: slideRightIn 0.8s ease forwards;
  }
  .fade-slide.zoom-in.active {
    animation: zoomIn 0.8s ease forwards;
  }
  .fade-slide.flip.active {
    animation: flipIn 0.8s ease forwards;
  }

  @keyframes slideLeftIn {
    from { transform: translateX(-100%); opacity: 0; }
    to { transform: translateX(0); opacity: 1; }
  }
  @keyframes slideRightIn {
    from { transform: translateX(100%); opacity: 0; }
    to { transform: translateX(0); opacity: 1; }
  }
  @keyframes zoomIn {
    from { transform: scale(0.8); opacity: 0; }
    to { transform: scale(1); opacity: 1; }
  }
  @keyframes flipIn {
    from { transform: rotateY(90deg); opacity: 0; }
    to { transform: rotateY(0deg); opacity: 1; }
  }

  /* Card */
  #adverts .advert-card {
    width: 100%; height: 100%;
    border: none;
    border-radius: 15px;
    overflow: hidden;
    transition: transform 0.3s ease;
  }
  #adverts .advert-card:hover {
    transform: translateY(-4px);
  }

  #adverts .advert-card img.card-img-top {
    height: 240px;
    object-fit: cover;
  }

  #adverts .advert-card .badge {
    font-size: 0.9rem;
    font-weight: 500;
    background: #198754;
    border-radius: 30px;
    box-shadow: 0 3px 6px rgba(0,0,0,0.2);
  }

  #adverts .card-body {
    padding: 1rem 1.2rem;
    text-align: left;
  }
  #adverts .card-body h6 {
    font-weight: 600;
    margin-bottom: 0.5rem;
    color: #0d6efd;
  }
  #adverts .card-body p {
    font-size: 0.9rem;
    color: #555;
  }

  #adverts .card-body .btn {
    width: 100%;
    border-radius: 30px;
    font-weight: 500;
    transition: transform 0.2s, background-color 0.2s;
  }
  #adverts .card-body .btn:hover {
    transform: scale(1.05);
    background-color: #0b5ed7;
  }

  /* Slider navigation */
  #adverts .fade-prev,
  #adverts .fade-next {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    background-color: rgba(0,0,0,0.55);
    color: #fff;
    border: none;
    width: 46px;
    height: 46px;
    font-size: 1.3rem;
    cursor: pointer;
    border-radius: 50%;
    z-index: 10;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: background-color 0.2s;
  }
  #adverts .fade-prev:hover,
  #adverts .fade-next:hover {
    background-color: rgba(0,0,0,0.8);
  }
  #adverts .fade-prev { left: 12px; }
  #adverts .fade-next { right: 12px; }

  /* Responsive */
  @media(max-width:576px) {
    #adverts .fade-slider {
      max-width: 95%;
      height: 460px;
    }
    #adverts .fade-prev,
    #adverts .fade-next {
      width: 38px; height: 38px;
      font-size: 1.1rem;
    }
  }
  </style>
</section>
<?php endif; ?>



  <!-- How it Works -->
<section id="how-it-works" class="py-5" style="background: #000;">
  <div class="container text-center">
    <h2 class="fw-bold mb-5" style="color:#fff;">How It Works</h2>
    
    <div class="row row-cols-1 row-cols-md-4 g-4">
      <!-- Step 1 -->
      <div class="col">
        <div class="card h-100 shadow-sm border-0 step-card animate-step" style="transition-delay:0.1s;">
          <div class="card-body">
            <div class="icon-circle bg-primary mb-3">
              <i class="fas fa-gem fa-2x text-white"></i>
            </div>
            <h5 class="fw-bold">1. Choose Plan</h5>
            <p class="text-muted small">Select a subscription – it’s free to get started.</p>
          </div>
        </div>
      </div>

      <!-- Step 2 -->
      <div class="col">
        <div class="card h-100 shadow-sm border-0 step-card animate-step" style="transition-delay:0.2s;">
          <div class="card-body">
            <div class="icon-circle bg-success mb-3">
              <i class="fas fa-user-plus fa-2x text-white"></i>
            </div>
            <h5 class="fw-bold">2. Sign Up</h5>
            <p class="text-muted small">Create your free agent account in a few clicks.</p>
          </div>
        </div>
      </div>

      <!-- Step 3 -->
      <div class="col">
        <div class="card h-100 shadow-sm border-0 step-card animate-step" style="transition-delay:0.3s;">
          <div class="card-body">
            <div class="icon-circle bg-warning mb-3">
              <i class="fas fa-bullhorn fa-2x text-white"></i>
            </div>
            <h5 class="fw-bold">3. Upload & Advertise</h5>
            <p class="text-muted small">List properties & adverts to reach buyers and renters.</p>
          </div>
        </div>
      </div>

      <!-- Step 4 -->
      <div class="col">
        <div class="card h-100 shadow-sm border-0 step-card animate-step" style="transition-delay:0.4s;">
          <div class="card-body">
            <div class="icon-circle bg-purple mb-3">
              <i class="fas fa-chart-line fa-2x text-white"></i>
            </div>
            <h5 class="fw-bold">4. Manage Dashboard</h5>
            <p class="text-muted small">Track visits, manage listings, and grow your reach.</p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Internal CSS -->
  <style>
    .icon-circle {
      width: 70px;
      height: 70px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto;
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    .bg-purple { background: #6f42c1 !important; }
    .step-card {
      border-radius: 12px;
      transform: translateY(30px);
      opacity: 0;
      transition: all 0.6s ease;
    }
    .step-card.show {
      transform: translateY(0);
      opacity: 1;
    }
  </style>

  <!-- Internal JS -->
  <script>
    document.addEventListener("DOMContentLoaded", function() {
      const steps = document.querySelectorAll(".animate-step");
      const observer = new IntersectionObserver(entries => {
        entries.forEach((entry, i) => {
          if (entry.isIntersecting) {
            entry.target.classList.add("show");
            observer.unobserve(entry.target);
          }
        });
      }, { threshold: 0.2 });

      steps.forEach(step => observer.observe(step));
    });
  </script>
</section>


  <!-- Featured Agents 
  <section id="featured-agents" class="container py-5">
    <div class="section-placeholder">FEATURED AGENTS - agent cards & contact CTA (self-contained)</div>
    <div class="dev-note">Agent profiles, ratings, quick contact buttons.</div>
  </section> -->

  <!-- Subscription Plans -->
 <section id="subscription" class="py-5">
  <style>
    /* Section background */
    #subscription {
      background: linear-gradient(135deg, #f8f9fa, #e9f5ff);
    }

    .subscription-card {
      border-radius: 15px;
      overflow: hidden;
      transition: transform 0.4s, box-shadow 0.4s;
      opacity: 0;
      transform: translateY(40px);
      background-color: #000;
    }

    .subscription-card.show {
      opacity: 1;
      transform: translateY(0);
    }

    .card-header {
      padding: 25px;
      font-weight: bold;
      font-size: 20px;
    }

    .card-header.basic {
      background: #6c757d;
      color: #fff;
    }

    .card-header.gold {
      background: #ffc107;
      color: #000;
    }

    .card-header.premium {
      background: #007bff;
      color: #fff;
    }

    .features li {
      padding: 10px 0;
      font-size: 15px;
      display: flex;
      align-items: center;
      gap: 10px;
      color: #fff;
    }

    .subscription-card:hover {
      transform: translateY(-8px);
      box-shadow: 0 12px 28px rgba(0, 0, 0, 0.15);
    }

    /* Ribbon for Premium */
    .premium-card {
      position: relative;
      border: 2px solid #007bff;
    }

    .ribbon {
      width: 140px;
      background: #ff4757;
      color: #fff;
      text-align: center;
      line-height: 28px;
      transform: rotate(45deg);
      position: absolute;
      right: -35px;
      top: 20px;
      font-size: 13px;
      box-shadow: 0 3px 8px rgba(0, 0, 0, 0.2);
    }
  </style>

  <div class="container">
    <h2 class="text-center mb-5 fw-bold">Choose Your Subscription Plan</h2>
    <div class="row g-4 justify-content-center">

      <!-- Basic Plan -->
      <div class="col-md-4">
        <div class="card subscription-card h-100">
          <div class="card-header basic text-center">
            <i class="fas fa-home fa-2x mb-2"></i>
            <h4>Basic</h4>
          </div>
          <div class="card-body">
            <ul class="list-unstyled features">
              <li><i class="fas fa-check text-success"></i> 10 Property Uploads</li>
              <li><i class="fas fa-check text-success"></i> 10 Adverts</li>
              <li><i class="fas fa-chart-line text-blue"></i> Low Advert Visibility</li>
              <li><i class="fas fa-building text-blue"></i> Rentals Only</li>
              <li><i class="fas fa-image text-blue"></i> 5 Media Uploads per Property</li>
              <li><i class="fas fa-user text-blue"></i> Standard Listing</li>
              <li><i class="fas fa-ban text-danger"></i> No Analytics</li>
            </ul>
          </div>
          <div class="card-footer text-center bg-white">
            <form action="agent_reg.php" method="post">
              <input type="hidden" name="plan" value="Basic">
              <button type="submit" class="btn btn-outline-secondary w-100">Get Started</button>
            </form>
          </div>
        </div>
      </div>

      <!-- Gold Plan -->
      <div class="col-md-4">
        <div class="card subscription-card h-100">
          <div class="card-header gold text-center">
            <i class="fas fa-star fa-2x mb-2"></i>
            <h4>Gold</h4>
          </div>
          <div class="card-body">
            <ul class="list-unstyled features">
              <li><i class="fas fa-check text-success"></i> 25 Property Uploads</li>
              <li><i class="fas fa-check text-success"></i> 25 Adverts</li>
              <li><i class="fas fa-chart-line text-dark"></i> Moderate Advert Visibility</li>
              <li><i class="fas fa-building text-dark"></i> Rentals & Sales</li>
              <li><i class="fas fa-image text-dark"></i> 5 Media Uploads per Property</li>
              <li><i class="fas fa-user-check text-dark"></i> Featured Agent (Occasional)</li>
              <li><i class="fas fa-chart-pie text-dark"></i> Basic Analytics</li>
            </ul>
          </div>
          <div class="card-footer text-center bg-white">
            <form action="agent_reg.php" method="post">
              <input type="hidden" name="plan" value="Gold">
              <button type="submit" class="btn btn-warning w-100 text-dark">Subscribe Now</button>
            </form>
          </div>
        </div>
      </div>

      <!-- Premium Plan -->
      <div class="col-md-4">
        <div class="card subscription-card h-100 premium-card">
          <div class="ribbon"><span>Most Popular</span></div>
          <div class="card-header premium text-center">
            <i class="fas fa-crown fa-2x mb-2"></i>
            <h4>Premium</h4>
          </div>
          <div class="card-body">
            <ul class="list-unstyled features">
              <li><i class="fas fa-check text-success"></i> Unlimited Property Uploads</li>
              <li><i class="fas fa-check text-success"></i> Unlimited Adverts</li>
              <li><i class="fas fa-rocket text-blue"></i> Priority Advert Visibility</li>
              <li><i class="fas fa-trophy text-blue"></i> Premium Properties Access</li>
              <li><i class="fas fa-image text-blue"></i> 5 Media Uploads per Property</li>
              <li><i class="fas fa-user-tie text-blue"></i> Always Featured as Top Agent</li>
              <li><i class="fas fa-chart-line text-blue"></i> Advanced Analytics</li>
            </ul>
          </div>
          <div class="card-footer text-center bg-white">
            <form action="agent_reg.php" method="post">
              <input type="hidden" name="plan" value="Premium">
              <button type="submit" class="btn btn-primary w-100">Go Premium</button>
            </form>
          </div>
        </div>
      </div>

    </div>
  </div>

  <!-- Animation Script -->
  <script>
    document.addEventListener("DOMContentLoaded", function() {
      const cards = document.querySelectorAll(".subscription-card");
      cards.forEach((card, index) => {
        setTimeout(() => {
          card.classList.add("show");
        }, index * 200); // staggered animation
      });
    });
  </script>
</section>

<!-- FontAwesome (for icons) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">


  <!-- Testimonials / Success Stories -->
  <!-- <section id="testimonials" class="container py-5">
    <div class="section-placeholder">TESTIMONIALS / SUCCESS STORIES (self-contained)</div>
  </section> -->


<!-- ===== BLOG SECTION ===== -->
<section class="blog-section">
  <div class="container">
    <h2 class="section-title">Latest Insights</h2>
    <div class="blog-grid">
      <!-- Blog Post 1 -->
      <div class="blog-card">
        <img src="images/limac.jpeg" alt="First-Time Home Buyers">
        <div class="blog-content">
          <h3>5 Tips for First-Time Home Buyers</h3>
          <p class="excerpt">Navigating the property market can be daunting for first-time buyers. Here are five essential tips...</p>
          <button class="read-more-btn" data-modal="modal1">Read More</button>
        </div>
      </div>
      <!-- Blog Post 2 -->
      <div class="blog-card">
        <img src="images/limac.jpeg" alt="Market Trends">
        <div class="blog-content">
          <h3>Port Harcourt Market Trends 2025</h3>
          <p class="excerpt">Stay ahead of the curve with the latest property market trends in Port Harcourt...</p>
          <button class="read-more-btn" data-modal="modal2">Read More</button>
        </div>
      </div>
      <!-- Blog Post 3 -->
      <div class="blog-card">
        <img src="https://images.pexels.com/photos/106399/pexels-photo-106399.jpeg?auto=compress&cs=tinysrgb&w=600" alt="Property Value">
        <div class="blog-content">
          <h3>How to Increase Your Property Value</h3>
          <p class="excerpt">Simple renovations and strategic improvements can boost your property's market value...</p>
          <button class="read-more-btn" data-modal="modal3">Read More</button>
        </div>
      </div>
      <!-- Blog Post 4 -->
      <div class="blog-card">
        <img src="https://images.pexels.com/photos/106399/pexels-photo-106399.jpeg?auto=compress&cs=tinysrgb&w=600" alt="Documents">
        <div class="blog-content">
          <h3>Essential Documents When Buying a Property</h3>
          <p class="excerpt">Ensure a smooth transaction by preparing these essential property documents...</p>
          <button class="read-more-btn" data-modal="modal4">Read More</button>
        </div>
      </div>
      <!-- Blog Post 5 -->
      <div class="blog-card">
        <img src="images/limac.jpeg" alt="Property Manager">
        <div class="blog-content">
          <h3>Choosing the Right Property Manager</h3>
          <p class="excerpt">Selecting a reliable property manager is crucial for maintaining your investment...</p>
          <button class="read-more-btn" data-modal="modal5">Read More</button>
        </div>
      </div>
      <!-- Blog Post 6 -->
      <div class="blog-card">
        <img src="https://images.pexels.com/photos/106399/pexels-photo-106399.jpeg?auto=compress&cs=tinysrgb&w=600" alt="Rental Insights">
        <div class="blog-content">
          <h3>Rental Market Insights</h3>
          <p class="excerpt">Gain a deeper understanding of rental market dynamics and explore trends and opportunities...</p>
          <button class="read-more-btn" data-modal="modal6">Read More</button>
        </div>
      </div>
      <!-- Blog Post 7 -->
      <div class="blog-card">
        <img src="https://images.pexels.com/photos/276724/pexels-photo-276724.jpeg?auto=compress&cs=tinysrgb&w=600" alt="Luxury Homes">
        <div class="blog-content">
          <h3>Investing in Luxury Homes</h3>
          <p class="excerpt">Luxury properties offer high potential returns. Learn how to choose the right one...</p>
          <button class="read-more-btn" data-modal="modal7">Read More</button>
        </div>
      </div>
      <!-- Blog Post 8 -->
      <div class="blog-card">
        <img src="https://images.pexels.com/photos/259588/pexels-photo-259588.jpeg?auto=compress&cs=tinysrgb&w=600" alt="Land Investment">
        <div class="blog-content">
          <h3>The Smart Way to Invest in Land</h3>
          <p class="excerpt">Land banking can be a profitable long-term strategy. Here's what you should know...</p>
          <button class="read-more-btn" data-modal="modal8">Read More</button>
        </div>
      </div>
    </div>
  </div>

  <!-- ===== MODALS ===== -->
  <div id="modal1" class="modal"><div class="modal-content"><span class="close">&times;</span><h2>5 Tips for First-Time Home Buyers</h2><p>Buying your first property in Port Harcourt can be overwhelming. Make sure to do thorough research, work with a trusted agency, inspect properties carefully, manage your finances, and consult legal experts. <strong>For more information, contact Limac Group.</strong></p></div></div>
  <div id="modal2" class="modal"><div class="modal-content"><span class="close">&times;</span><h2>Port Harcourt Market Trends 2025</h2><p>The real estate market in Port Harcourt is evolving rapidly. Demand for residential properties remains strong, and strategic investments can yield high returns. <strong>For more information, contact Limac Group.</strong></p></div></div>
  <div id="modal3" class="modal"><div class="modal-content"><span class="close">&times;</span><h2>How to Increase Your Property Value</h2><p>Simple renovations and maintenance tips can significantly boost your property's market value. Limac Group can advise on the best improvements. <strong>For more information, contact us.</strong></p></div></div>
  <div id="modal4" class="modal"><div class="modal-content"><span class="close">&times;</span><h2>Essential Documents When Buying a Property</h2><p>Ensure a smooth property transaction by preparing these essential documents in advance. Limac Groups can guide you through the process. <strong>For more information, contact us.</strong></p></div></div>
  <div id="modal5" class="modal"><div class="modal-content"><span class="close">&times;</span><h2>Choosing the Right Property Manager</h2><p>Selecting a reliable property manager is crucial for maintaining your investment. Learn what qualities matter most. <strong>For more information, contact Limac Groups.</strong></p></div></div>
  <div id="modal6" class="modal"><div class="modal-content"><span class="close">&times;</span><h2>Rental Market Insights</h2><p>Gain a deeper understanding of rental market dynamics. Explore trends, challenges, and opportunities. <strong>For more information, contact Limac Groups.</strong></p></div></div>
  <div id="modal7" class="modal"><div class="modal-content"><span class="close">&times;</span><h2>Investing in Luxury Homes</h2><p>Luxury homes not only offer prestige but also strong investment potential. Our experts can help you choose properties with high growth prospects. <strong>Contact Limac Groups to learn more.</strong></p></div></div>
  <div id="modal8" class="modal"><div class="modal-content"><span class="close">&times;</span><h2>The Smart Way to Invest in Land</h2><p>Land investment can be a secure and profitable strategy if done right. We guide you in identifying prime locations and securing great deals. <strong>Reach out to us for expert advice.</strong></p></div></div>
</section>

<!-- ===== BLOG CSS ===== -->
<style>
:root {
  --section-bg-light: #fff5f5;
  --section-bg-dark: #121212;
  --card-bg-light: #ffffff;
  --card-bg-dark: #1c1c1c;
  --text-light: #333;
  --text-dark: #ddd;
  --accent-color: #b22222;
  --accent-hover: #ff6f61;
}

/* Blog Section */
.blog-section {
  padding: 60px 20px;
  background-color: var(--section-bg-light);
  text-align: center;
  min-height: 600px;
  box-sizing: border-box;
  margin-bottom: 40px;
  transition: background-color 0.3s ease;
}

body.dark-mode .blog-section {
  background-color: var(--section-bg-dark);
}

.section-title {
  font-size: 2.5rem;
  margin-bottom: 40px;
  color: var(--accent-color);
  font-weight: bold;
}

.blog-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
  gap: 30px;
  align-items: start;
}

/* Blog Cards */
.blog-card {
  background-color: var(--card-bg-light);
  color: var(--text-light);
  border-radius: 12px;
  overflow: hidden;
  box-shadow: 0 4px 10px rgba(0,0,0,0.1);
  transition: transform 0.3s, box-shadow 0.3s, background-color 0.3s ease;
}

body.dark-mode .blog-card {
  background-color: var(--card-bg-dark);
  color: var(--text-dark);
}

.blog-card img {
  width: 100%;
  height: 200px;
  object-fit: cover;
}

.blog-content {
  padding: 20px;
}

.blog-content h3 {
  color: var(--accent-color);
  margin-bottom: 10px;
  font-size: 1.2rem;
}

body.dark-mode .blog-content h3 {
  color: var(--accent-hover);
}

.blog-content p.excerpt {
  font-size: 0.95rem;
  margin-bottom: 15px;
}

/* Read More Button */
.read-more-btn {
  background-color: var(--accent-color);
  color: #fff;
  border: none;
  padding: 10px 20px;
  border-radius: 8px;
  cursor: pointer;
  transition: background 0.3s;
}

.read-more-btn:hover {
  background-color: var(--accent-hover);
}

/* Modals */
.modal {
  display: none;
  position: fixed;
  z-index: 999;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  overflow: auto;
  background-color: rgba(0,0,0,0.7);
}

.modal-content {
  background-color: var(--card-bg-light);
  color: var(--text-light);
  margin: 10% auto;
  padding: 30px;
  border-radius: 12px;
  max-width: 600px;
  position: relative;
  text-align: left;
}

body.dark-mode .modal-content {
  background-color: var(--card-bg-dark);
  color: var(--text-dark);
}

.modal-content h2 {
  color: var(--accent-color);
  margin-bottom: 15px;
}

body.dark-mode .modal-content h2 {
  color: var(--accent-hover);
}

.close {
  position: absolute;
  top: 15px;
  right: 20px;
  font-size: 28px;
  cursor: pointer;
}

.close:hover {
  color: var(--accent-hover);
}

/* Responsive Grid */
@media (max-width: 480px) {
  .blog-grid { grid-template-columns: 1fr; gap: 15px; }
}

@media (max-width: 767px) {
  .blog-grid { grid-template-columns: repeat(2, 1fr); gap: 20px; }
}

@media (min-width: 768px) and (max-width: 1024px) {
  .blog-grid { grid-template-columns: repeat(3, 1fr); gap: 25px; }
}
</style>

<!-- ===== BLOG JS MODAL ===== -->
<script>
document.addEventListener('DOMContentLoaded', () => {
  const buttons = document.querySelectorAll('.read-more-btn');
  const closes = document.querySelectorAll('.close');

  buttons.forEach(btn => {
    btn.addEventListener('click', () => {
      const modal = document.getElementById(btn.dataset.modal);
      modal.style.display = 'block';
    });
  });

  closes.forEach(span => {
    span.addEventListener('click', () => {
      span.closest('.modal').style.display = 'none';
    });
  });

  window.addEventListener('click', (e) => {
    if (e.target.classList.contains('modal')) {
      e.target.style.display = 'none';
    }
  });
});
</script>



<!-- FAQ Section-->
<section id="faq">
  <h2>Frequently Asked Questions</h2>
  <p>Here are some common questions our clients ask about our services.</p>

  <div class="faq-container">
    <div class="faq">
      <div class="faq-question"><i class="fas fa-plus"></i> What services do you provide?</div>
      <div class="faq-answer">We provide property management, real estate solutions, consultancy, and more tailored to your needs.</div>
    </div>
    <div class="faq">
      <div class="faq-question"><i class="fas fa-plus"></i> How can I get started?</div>
      <div class="faq-answer">Simply contact us through our website or call our office to schedule a consultation.</div>
    </div>
    <div class="faq">
      <div class="faq-question"><i class="fas fa-plus"></i> Do you manage commercial and residential properties?</div>
      <div class="faq-answer">Yes, we handle both commercial and residential properties with expertise and care.</div>
    </div>
    <div class="faq">
      <div class="faq-question"><i class="fas fa-plus"></i> How often do you inspect properties?</div>
      <div class="faq-answer">Our team conducts regular inspections monthly or as agreed in the management contract.</div>
    </div>
    <div class="faq">
      <div class="faq-question"><i class="fas fa-plus"></i> What fees are involved?</div>
      <div class="faq-answer">Fees depend on the service package chosen; we offer transparent pricing upfront.</div>
    </div>
    <div class="faq">
      <div class="faq-question"><i class="fas fa-plus"></i> Do you assist with tenant management?</div>
      <div class="faq-answer">Yes, we handle tenant communication, rent collection, and dispute resolution professionally.</div>
    </div>
    <div class="faq">
      <div class="faq-question"><i class="fas fa-plus"></i> Can you handle property maintenance and repairs?</div>
      <div class="faq-answer">Absolutely, we coordinate maintenance and repair work with trusted vendors promptly.</div>
    </div>
    <div class="faq">
      <div class="faq-question"><i class="fas fa-plus"></i> How can I contact you directly?</div>
      <div class="faq-answer">You can contact us via phone, email, or our online contact form for immediate support.</div>
    </div>
  </div>

  <style>
    #faq {
      padding: 60px 20px;
      background: #111;
      color: #fff;
    }

    #faq h2 {
      text-align: center;
      font-size: 2.5rem;
      color: #f00;
      margin-bottom: 10px;
    }

    #faq p {
      text-align: center;
      margin-bottom: 40px;
      color: #ccc;
    }

    .faq-container {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 20px;
      max-width: 1000px;
      margin: 0 auto;
    }

    @media (max-width: 768px) {
      .faq-container { grid-template-columns: 1fr; }
    }

    .faq {
      background: #222;
      border-radius: 8px;
      overflow: hidden;
      box-shadow: 0 4px 10px rgba(0,0,0,0.3);
    }

    .faq-question {
      cursor: pointer;
      padding: 15px 20px;
      font-size: 1.1rem;
      display: flex;
      justify-content: space-between;
      align-items: center;
      background: linear-gradient(90deg, #f00 0%, #111 100%);
      color: #fff;
      transition: background 0.3s;
    }

    .faq-question:hover {
      background: linear-gradient(90deg, #c00 0%, #111 100%);
    }

    .faq-question i {
      transition: transform 0.3s;
    }

    .faq-answer {
      display: none;
      padding: 15px 20px;
      font-size: 1rem;
      color: #ccc;
      background: #111;
      line-height: 1.5;
    }

    .faq.active .faq-answer {
      display: block;
    }

    .faq.active .faq-question i {
      transform: rotate(45deg);
    }
  </style>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
  <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
  <script>
    const faqs = document.querySelectorAll(".faq");
    faqs.forEach(faq => {
      const question = faq.querySelector(".faq-question");
      const answer = faq.querySelector(".faq-answer");

      question.addEventListener("click", () => {
        // Close others
        faqs.forEach(f => {
          if(f !== faq) f.classList.remove("active");
        });

        // Toggle current
        faq.classList.toggle("active");

        // Animate answer
        if(faq.classList.contains("active")){
          gsap.fromTo(answer, {height: 0, opacity:0}, {height: "auto", opacity:1, duration:0.5});
        } else {
          gsap.to(answer, {height: 0, opacity:0, duration:0.5});
        }
      });
    });
  </script>
</section>




  <!-- Footer -->
<footer id="footer" class="footer py-5 bg-dark text-light">
  <style>
    .footer .logo img {
      height: 50px;
      width: 50px;
      object-fit: cover;
      border-radius: 50%;
      margin-right: 10px;
    }
    .footer .logo span {
      font-size: 1.2rem;
      font-weight: 600;
    }
    .footer .tagline {
      font-size: 0.95rem;
      color: #adb5bd;
      margin-top: 5px;
    }
    .footer .social-icons a {
      font-size: 1.2rem;
      margin-right: 12px;
      color: #adb5bd;
      transition: color 0.3s;
    }
    .footer .social-icons a:hover {
      color: #fff;
    }
    .footer h5 {
      font-size: 1.1rem;
      font-weight: 600;
      margin-bottom: 15px;
    }
    .footer ul {
      list-style: none;
      padding: 0;
      margin: 0;
    }
    .footer ul li {
      margin-bottom: 10px;
    }
    .footer ul li a {
      color: #adb5bd;
      text-decoration: none;
      transition: color 0.3s;
    }
    .footer ul li a:hover {
      color: #fff;
    }
    .footer .contact-info p {
      margin-bottom: 8px;
      color: #adb5bd;
    }
    .footer .contact-info i {
      margin-right: 8px;
      color: var(--accent, #0d6efd);
    }
  </style>

  <div class="container">
    <div class="row">
      <!-- Column 1: Logo & Social -->
      <div class="col-md-4 mb-4">
        <div class="d-flex align-items-center logo">
          <img src="images/limac.jpeg" alt="Limac Logo">
          <span>Limac Groups</span>
        </div>
        <p class="tagline">Connecting you with the best real estate opportunities.</p>
        <div class="social-icons mt-2">
          <a href="https://www.facebook.com/share/15neJ5DBPE/"><i class="bi bi-facebook"></i></a>
          <!-- <a href="#"><i class="bi bi-twitter"></i></a> -->
          <a href="https://www.instagram.com/limaccourtslimited?igsh=MWM5a3gwZHNoMWt0aA=="><i class="bi bi-instagram"></i></a>
          <!-- <a href="#"><i class="bi bi-linkedin"></i></a> -->
        </div>
      </div>

      <!-- Column 2: Quick Links -->
      <div class="col-md-4 mb-4">
        <h5>Quick Links</h5>
        <ul>
          <li><a href="#hero"><i class="fas fa-home me-2" style="color:#007bff;"></i>Home</a></li>
          <li><a href="#properties"><i class="fas fa-building me-2" style="color:#28a745;"></i>Properties</a></li>
          <li><a href="#categories"><i class="fas fa-th-list me-2" style="color:#ffc107;"></i>Categories</a></li>
          <li><a href="#subscription"><i class="fas fa-credit-card me-2" style="color:#17a2b8;"></i>Subscription</a></li>
          <li><a href="login.php"><i class="fas fa-sign-in-alt me-2" style="color:#dc3545;"></i>Login</a></li>
        </ul>
      </div>

      <!-- Column 3: Contact Us -->
      <div class="col-md-4 mb-4">
        <h5>Contact Us</h5>
        <div class="contact-info">
          <p><i class="bi bi-geo-alt-fill"></i> Second floor, P&T Plaza beside Jodil Filling Station, SARS Road, Rupokwu.</p>
          <p><i class="bi bi-telephone-fill"></i> +234 706 697 2694</p>
          <p><i class="bi bi-envelope-fill"></i> contact@limacgroups.com</p>
        </div>
      </div>
    </div>

    <!-- Bottom Text -->
    <div class="text-center mt-4 pt-3 border-top border-secondary">
      <small>&copy; 2025 Limac Groups. All Rights Reserved.</small>
    </div>
  </div>
</footer>


  <!-- Floating Call & Chat Buttons -->
<style>
  .floating-buttons {
    position: fixed;
    bottom: 20px;
    right: 20px;
    display: flex;
    flex-direction: column;
    gap: 12px;
    z-index: 1050;
  }
  .floating-buttons a {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 10px 18px;
    border-radius: 30px;
    color: #fff;
    font-size: 1rem;
    font-weight: 500;
    text-decoration: none;
    box-shadow: 0 4px 10px rgba(0,0,0,0.25);
    transition: transform 0.2s ease, opacity 0.2s ease;
  }
  .floating-buttons a i {
    font-size: 1.3rem;
  }
  .floating-buttons a:hover {
    transform: scale(1.05);
    opacity: 0.95;
  }
  .call-btn { background-color: #0d6efd; }   /* Bootstrap primary */
  .chat-btn { background-color: #25D366; }  /* WhatsApp green */
</style>

<div class="floating-buttons">
  <!-- Call Button -->
  <a href="tel:07066972694" class="call-btn" title="Call Us">
    <i class="bi bi-telephone-fill"></i> Call Us
  </a>

  <!-- Chat Button -->
  <a href="https://wa.me/2347066972694" target="_blank" class="chat-btn" title="Chat with Us">
    <i class="bi bi-whatsapp"></i> Chat Us
  </a>
</div>

    <!-- Bootstrap JS Bundle (with Popper) -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>


</body>
</html>
