<?php
session_start();
require_once "config.php";

$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $login = trim($_POST["login"]);
    $password = $_POST["password"];

    // allow login via username OR email
    $stmt = $conn->prepare("SELECT * FROM users WHERE username = ? OR email = ? LIMIT 1");
    $stmt->bind_param("ss", $login, $login);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    if ($user && password_verify($password, $user["password"])) {
        // store session
        $_SESSION["user_id"] = $user["id"];
        $_SESSION["username"] = $user["username"];
        $_SESSION["role"] = $user["role"];
        $_SESSION["subscription_plan"] = $user["subscription_plan"];

        // update last login
        $update = $conn->prepare("UPDATE users SET last_login = NOW() WHERE id = ?");
        $update->bind_param("i", $user["id"]);
        $update->execute();

        // redirects
        if ($user["role"] === "admin") {
            header("Location: admin_dash.php");
        } elseif ($user["role"] === "staff") {
            header("Location: staff_dash.php");
        } elseif ($user["role"] === "basic") {
            header("Location: agent_dash.php");
        } elseif ($user["role"] === "gold") {
            header("Location: agent_dash.php");
        } elseif ($user["role"] === "premium") {
            header("Location: agent_dash.php");
        } else {
            $error = "Unknown role. Please contact support.";
        }
        exit;
    } else {
        $error = "Invalid login credentials.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>User Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(135deg, #74ebd5, #9face6);
      font-family: "Segoe UI", sans-serif;
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 20px;
    }
    .login-card {
      width: 100%;
      max-width: 400px;
      background: #fff;
      border-radius: 20px;
      padding: 45px 30px 35px;
      box-shadow: 0 8px 25px rgba(0,0,0,0.2);
      animation: fadeInUp 0.8s ease;
      text-align: center;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .login-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 12px 30px rgba(0,0,0,0.25);
    }
    .login-card img.logo {
      width: 90px;
      height: 90px;
      object-fit: cover;
      border-radius: 50%;
      margin-bottom: 20px;
      border: 2px solid #4a6cf7;
      transition: transform 0.3s ease;
    }
    .login-card img.logo:hover {
      transform: rotate(10deg);
    }
    .login-card h3 {
      font-weight: 600;
      color: #333;
      margin-bottom: 25px;
      font-size: 1.6rem;
    }
    .btn-custom {
      background: linear-gradient(90deg, #4a6cf7, #6b8cfb);
      color: #fff;
      border: none;
      border-radius: 12px;
      padding: 12px;
      font-size: 1rem;
      transition: all 0.3s ease;
    }
    .btn-custom:hover {
      background: linear-gradient(90deg, #3955c3, #5671f5);
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    .input-group-text {
      background: #f1f1f1;
      border: none;
      font-size: 1.1rem;
    }
    .form-control {
      border-radius: 8px;
      font-size: 0.95rem;
      padding: 10px 12px;
    }
    .login-card a {
      color: #4a6cf7;
      text-decoration: none;
      font-weight: 500;
    }
    .login-card a:hover {
      text-decoration: underline;
    }
    @keyframes fadeInUp {
      from { opacity: 0; transform: translateY(20px); }
      to { opacity: 1; transform: translateY(0); }
    }

    /* Responsive adjustments */
    @media (max-width: 480px) {
      .login-card {
        padding: 35px 20px 25px;
      }
      .login-card h3 {
        font-size: 1.4rem;
      }
      .btn-custom {
        padding: 10px;
        font-size: 0.95rem;
      }
      .login-card img.logo {
        width: 75px;
        height: 75px;
      }
    }
  </style>
</head>
<body>
  <div class="login-card">
    <img src="images/limac.jpeg" alt="Logo" class="logo">
    <h3><i class="fas fa-user-circle me-2"></i>User Login</h3>
    
    <?php if (!empty($error)): ?>
      <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form action="login.php" method="POST">
      <div class="mb-3 input-group">
        <span class="input-group-text"><i class="fas fa-user"></i></span>
        <input type="text" name="login" class="form-control" placeholder="Email or Username" required>
      </div>
      <div class="mb-3 input-group">
        <span class="input-group-text"><i class="fas fa-lock"></i></span>
        <input type="password" name="password" class="form-control" placeholder="Password" required>
      </div>
      <div class="d-grid">
        <button type="submit" class="btn btn-custom"><i class="fas fa-sign-in-alt me-1"></i> Login</button>
      </div>
      <!-- <p class="text-center mt-3 mb-1">
        <a href="forgot_password.php"><i class="fas fa-unlock-alt me-1"></i> Forgot Password?</a>
      </p> -->
      <p class="text-center">
        Don't have an account? <a href="index.php#subscription">Register</a>
      </p>
    </form>
  </div>
</body>
</html>


