<?php
session_start();
require_once "config.php"; // Your DB connection

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $inspection_id = isset($_POST['inspection_id']) ? (int)$_POST['inspection_id'] : 0;

    if ($inspection_id > 0) {
        // Delete the inspection request
        $stmt = $conn->prepare("DELETE FROM property_inspections WHERE id = ?");
        $stmt->bind_param("i", $inspection_id);

        if ($stmt->execute()) {
            $_SESSION['success'] = "Inspection request deleted successfully.";
        } else {
            $_SESSION['error'] = "Error deleting inspection: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $_SESSION['error'] = "Invalid inspection ID.";
    }

    // Redirect back to admin dashboard
    header("Location: admin_dash.php");
    exit;
} else {
    die("Invalid request method.");
}
?>
