<?php
session_start();
require_once "config.php";

if($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate input
    $property_id = intval($_POST['property_id'] ?? 0);
    $name = trim($_POST['name'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $inspection_date = $_POST['inspection_date'] ?? '';

    if(!$property_id || !$name || !$phone || !$inspection_date){
        $_SESSION['error'] = "Please fill in all required fields.";
        header("Location: index.php#admin-properties");
        exit;
    }

    // Insert into DB
    $stmt = $conn->prepare("INSERT INTO property_inspections (property_id, name, phone, email, inspection_date) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("issss", $property_id, $name, $phone, $email, $inspection_date);

    if($stmt->execute()){
        $_SESSION['success'] = "Your inspection request has been submitted successfully!";
    } else {
        $_SESSION['error'] = "Error submitting request: " . $stmt->error;
    }

    header("Location: index.php#admin-properties");
    exit;
} else {
    die("Invalid request method.");
}
