<?php
require_once "config.php";

$type = $_GET['type'] ?? '';
$location = $_GET['location'] ?? '';
$min_price = $_GET['min_price'] ?? '';
$max_price = $_GET['max_price'] ?? '';

$sql = "SELECT p.*, 
        (SELECT GROUP_CONCAT(image_path SEPARATOR ',') FROM property_images WHERE property_id = p.id) AS images
        FROM properties p
        WHERE 1=1";

$params = [];
$types = '';

if($type) {
    $sql .= " AND type = ?";
    $params[] = $type;
    $types .= 's';
}
if($location) {
    $sql .= " AND location = ?";
    $params[] = $location;
    $types .= 's';
}
if($min_price !== '') {
    $sql .= " AND (price >= ? OR total_package >= ?)";
    $params[] = $min_price;
    $params[] = $min_price;
    $types .= 'ii';
}
if($max_price !== '') {
    $sql .= " AND (price <= ? OR total_package <= ?)";
    $params[] = $max_price;
    $params[] = $max_price;
    $types .= 'ii';
}

$stmt = $conn->prepare($sql);
if(!empty($params)){
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

$properties = [];
while($prop = $result->fetch_assoc()){
    $prop['images'] = explode(',', $prop['images']);
    $properties[] = $prop;
}
?>

<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<section class="container py-5">
  <h4 class="mb-4 text-center">Search Results</h4>
  <div class="row g-4">
    <?php if(!empty($properties)): ?>
        <?php foreach($properties as $prop): 
            $img = !empty($prop['images'][0]) ? $prop['images'][0] : 'placeholder.jpg';
            $badge = $prop['type']==='sale' ? 'Sale' : 'Rental';
            $display_price = $prop['type']==='rent' ? $prop['total_package'] : $prop['price'];
        ?>
        <div class="col-sm-6 col-md-4 col-lg-3">
          <div class="card shadow-sm h-100 position-relative property-card">
            <span class="badge bg-success position-absolute top-0 start-0 m-3 px-3 py-2 fs-6"><?= $badge ?></span>
            <img src="<?= htmlspecialchars($img) ?>" class="card-img-top" style="height:180px; object-fit:cover;" alt="Property Image">
            <div class="card-body d-flex flex-column justify-content-between">
              <h6 class="card-title"><?= htmlspecialchars($prop['title']) ?></h6>
              <p class="mb-1"><strong>Price:</strong> ₦<?= number_format($display_price) ?></p>
              <p class="card-text"><?= substr(htmlspecialchars($prop['description']),0,60) ?>...</p>
              <p class="mb-2"><strong>Location:</strong> <?= htmlspecialchars($prop['location']) ?></p>
              <a href="view_details.php?id=<?= $prop['id'] ?>" class="btn btn-primary mt-2">View Details</a>
            </div>
          </div>
        </div>
        <?php endforeach; ?>
    <?php else: ?>
      <p class="text-center">No properties found matching your search criteria.</p>
    <?php endif; ?>
  </div>
</section>

<style>
.property-card {
    transition: transform 0.2s, box-shadow 0.2s;
}
.property-card:hover {
    transform: scale(1.03);
    box-shadow: 0 8px 20px rgba(0,0,0,0.2);
}
.card-body .btn {
    width: 100%;
}
.card-body .btn:hover {
    transform: scale(1.05);
    transition: 0.2s;
}
</style>
