<?php
require_once "config.php";

$property_id = isset($_GET['property_id']) ? intval($_GET['property_id']) : 0;

$res = $conn->query("SELECT * FROM admin_properties WHERE id=$property_id");
$property = $res->fetch_assoc();

if(!$property){
    echo "Property not found";
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= htmlspecialchars($property['property_type']) ?> - Limac Courts</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body {
    background: #f8f9fa;
    font-family: 'Segoe UI', sans-serif;
}

.welcome-section {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 40px;
    background: #fff;
    padding: 20px;
    border-radius: 12px;
    box-shadow: 0 6px 18px rgba(0,0,0,0.1);
}

.welcome-section img {
    width: 80px;
    height: 80px;
    object-fit: contain;
    border-radius: 50%;
}

.property-card {
    background: #fff;
    padding: 20px;
    border-radius: 12px;
    box-shadow: 0 6px 18px rgba(0,0,0,0.1);
    margin-bottom: 40px;
}

.property-card img {
    width: 100%;
    max-height: 400px;
    object-fit: cover;
    border-radius: 12px;
    margin-bottom: 15px;
}

.property-info p {
    margin: 0.5rem 0;
    font-size: 1rem;
}

.cta-card {
    background: linear-gradient(135deg, #ff9a00, #ff6a00);
    color: #fff;
    padding: 30px;
    border-radius: 12px;
    text-align: center;
    box-shadow: 0 6px 18px rgba(0,0,0,0.15);
    margin-bottom: 40px;
}

.cta-card h4 {
    font-weight: 600;
    margin-bottom: 15px;
}

.cta-card p {
    font-size: 1rem;
    margin-bottom: 20px;
}

.cta-card a.btn {
    background: #fff;
    color: #ff6a00;
    font-weight: 600;
    padding: 10px 25px;
    border-radius: 50px;
    text-decoration: none;
    transition: all 0.3s ease;
}

.cta-card a.btn:hover {
    background: #ffe6cc;
    color: #ff6a00;
}
</style>
</head>
<body>

<div class="container py-5">

    <!-- Welcome Section -->
    <div class="welcome-section">
        <img src="images/limac.jpeg" alt="Limac Courts Logo">
        <div>
            <h3 class="mb-1">Welcome to Limac Courts Limited</h3>
            <p>Your gateway to premium real estate investments.</p>
        </div>
    </div>

    <!-- Property Card -->
    <div class="property-card">
        <img src="<?= htmlspecialchars($property['property_image']) ?>" alt="<?= htmlspecialchars($property['description']) ?>">
        <div class="property-info">
            <p><strong>Type:</strong> <?= htmlspecialchars($property['property_type']) ?></p>
            <p><strong>Description:</strong> <?= htmlspecialchars($property['description']) ?></p>
            <p><strong>Price:</strong> ₦<?= number_format($property['price'], 2) ?></p>
            <p><strong>Location:</strong> <?= htmlspecialchars($property['location']) ?></p>
        </div>
    </div>

    <!-- CTA Section -->
    <div class="cta-card">
        <h4>Looking for a Specific Property?</h4>
        <p>Let us know your budget and preference and we can guide you into real estate investment.</p>
        <a href="contact.php" class="btn">Start Now</a>
    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
