<?php
session_start();
require_once "config.php";

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$agent_id = intval($_SESSION['user_id']);
$id = intval($_GET['id']);

$sql = "SELECT * FROM properties WHERE id = $id AND user_id = $agent_id";
$result = $conn->query($sql);

if ($result->num_rows === 0) {
    echo "<p class='text-center text-danger mt-5'>Property not found or unauthorized access.</p>";
    exit;
}

$property = $result->fetch_assoc();

// Fetch images
$images = [];
$imgRes = $conn->query("SELECT image_path FROM property_images WHERE property_id = $id");
while ($row = $imgRes->fetch_assoc()) {
    $images[] = $row['image_path'];
}

// Fetch video
$video = null;
$vidRes = $conn->query("SELECT video_path FROM property_videos WHERE property_id = $id LIMIT 1");
if ($vidRes->num_rows > 0) {
    $video = $vidRes->fetch_assoc()['video_path'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Property Details</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #f4f6f9;
    }
    .property-card {
      background: #fff;
      border-radius: 12px;
      padding: 20px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
      margin-top: 20px;
    }
    h2 {
      color: #2c3e50;
      font-weight: bold;
    }
    .property-info p strong {
      color: #34495e;
    }
    .status {
      display: inline-block;
      padding: 4px 10px;
      border-radius: 8px;
      font-size: 14px;
      font-weight: 600;
    }
    .status.available { background: #d4edda; color: #155724; }
    .status.sold { background: #f8d7da; color: #721c24; }
    .status.rented { background: #d1ecf1; color: #0c5460; }
    .status.pending { background: #fff3cd; color: #856404; }
  </style>
</head>
<body class="container py-5">

  <!-- Carousel -->
  <?php if (!empty($images)): ?>
    <div id="propertyCarousel" class="carousel slide shadow mb-4" data-bs-ride="carousel">
      <div class="carousel-inner rounded">
        <?php foreach ($images as $index => $img): ?>
          <div class="carousel-item <?= $index === 0 ? 'active' : '' ?>">
            <img src="<?= $img ?>" class="d-block w-100" style="max-height:450px; object-fit:cover;">
          </div>
        <?php endforeach; ?>
      </div>
      <?php if (count($images) > 1): ?>
        <button class="carousel-control-prev" type="button" data-bs-target="#propertyCarousel" data-bs-slide="prev">
          <span class="carousel-control-prev-icon"></span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#propertyCarousel" data-bs-slide="next">
          <span class="carousel-control-next-icon"></span>
        </button>
      <?php endif; ?>
    </div>
  <?php endif; ?>

  <!-- Property Details -->
  <div class="property-card">
    <h2><?= htmlspecialchars($property['title']) ?></h2>
    <p class="status <?= $property['status'] ?>"><?= ucfirst($property['status']) ?></p>

    <div class="property-info mt-3">
      <p><strong>Type:</strong> <?= ucfirst($property['type']) ?></p>
      <p><strong>Category:</strong> <?= ucfirst($property['category']) ?></p>
      <p><strong>Price:</strong> #<?= number_format($property['price'], 2) ?></p>

      <?php if ($property['type'] === 'rent'): ?>
        <hr>
        <h5 class="text-primary">Rental Details</h5>
        <p><strong>Monthly Fee:</strong> #<?= number_format($property['monthly_fee'], 2) ?></p>
        <p><strong>Yearly Fee:</strong> #<?= number_format($property['yearly_fee'], 2) ?></p>
        <p><strong>Agency Fee:</strong> #<?= number_format($property['agency_fee'], 2) ?></p>
        <p><strong>Total Package:</strong> #<?= number_format($property['total_package'], 2) ?></p>
      <?php endif; ?>

      <hr>
      <p><strong>Location:</strong> <?= htmlspecialchars($property['location']) ?></p>
      <p><strong>Description:</strong><br> <?= nl2br(htmlspecialchars($property['description'])) ?></p>
    </div>

    <?php if ($video): ?>
      <hr>
      <h5>Video Tour</h5>
      <video controls class="w-100 rounded shadow-sm mt-2">
        <source src="<?= $video ?>" type="video/mp4">
        Your browser does not support the video tag.
      </video>
    <?php endif; ?>

    <a href="agent_dash.php" class="btn btn-secondary mt-4">← Back to Dashboard</a>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
